/*
Navicat MySQL Data Transfer

Source Server         : 172.16.11.20
Source Server Version : 50717
Source Host           : 172.16.11.20:3306
Source Database       : amos_maintenance_v1.0

Target Server Type    : MYSQL
Target Server Version : 50717
File Encoding         : 65001

Date: 2021-07-30 15:12:35
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for databasechangelog
-- ----------------------------
DROP TABLE IF EXISTS `databasechangelog`;
CREATE TABLE `databasechangelog` (
                                     `ID` varchar(255) NOT NULL,
                                     `AUTHOR` varchar(255) NOT NULL,
                                     `FILENAME` varchar(255) NOT NULL,
                                     `DATEEXECUTED` datetime NOT NULL,
                                     `ORDEREXECUTED` int(11) NOT NULL,
                                     `EXECTYPE` varchar(10) NOT NULL,
                                     `MD5SUM` varchar(35) DEFAULT NULL,
                                     `DESCRIPTION` varchar(255) DEFAULT NULL,
                                     `COMMENTS` varchar(255) DEFAULT NULL,
                                     `TAG` varchar(255) DEFAULT NULL,
                                     `LIQUIBASE` varchar(20) DEFAULT NULL,
                                     `CONTEXTS` varchar(255) DEFAULT NULL,
                                     `LABELS` varchar(255) DEFAULT NULL,
                                     `DEPLOYMENT_ID` varchar(10) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of databasechangelog
-- ----------------------------
INSERT INTO `databasechangelog` VALUES ('1587367889717-2', 'suhuiguang', 'classpath:/db/changelog/mt-1.0.0.xml', '2021-07-30 15:13:42', '1', 'EXECUTED', '8:fa5962c0b3576e3c8a039a2c52608f0c', 'sql', 'p_point ADD COLUMN last_check_id', null, '3.6.3', null, null, '7629079352');

-- ----------------------------
-- Table structure for databasechangeloglock
-- ----------------------------
DROP TABLE IF EXISTS `databasechangeloglock`;
CREATE TABLE `databasechangeloglock` (
                                         `ID` int(11) NOT NULL,
                                         `LOCKED` bit(1) NOT NULL,
                                         `LOCKGRANTED` datetime DEFAULT NULL,
                                         `LOCKEDBY` varchar(255) DEFAULT NULL,
                                         PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of databasechangeloglock
-- ----------------------------
INSERT INTO `databasechangeloglock` VALUES ('1', '\0', null, null);

-- ----------------------------
-- Table structure for p_app_version
-- ----------------------------
DROP TABLE IF EXISTS `p_app_version`;
CREATE TABLE `p_app_version` (
                                 `id` bigint(20) NOT NULL AUTO_INCREMENT,
                                 `version` varchar(255) DEFAULT NULL COMMENT '版本号',
                                 `remark` longtext COMMENT '说明',
                                 `create_date` datetime DEFAULT NULL COMMENT '创建时间',
                                 `publisher` int(255) DEFAULT NULL COMMENT '发布者id',
                                 `publisher_name` varchar(255) DEFAULT NULL COMMENT '发布者名称',
                                 `update_type` int(11) DEFAULT NULL COMMENT '版本更新类型：1.强制更新，2.非强制更新',
                                 `is_latest_version` bit(1) DEFAULT NULL COMMENT '是否为最新版本',
                                 `url` longtext COMMENT 'app文件保存路径',
                                 PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_app_version
-- ----------------------------

-- ----------------------------
-- Table structure for p_catalog_tree
-- ----------------------------
DROP TABLE IF EXISTS `p_catalog_tree`;
CREATE TABLE `p_catalog_tree` (
                                  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '分类id',
                                  `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
                                  `name` varchar(100) NOT NULL COMMENT '分类名称',
                                  `order_no` int(11) NOT NULL COMMENT '排序号',
                                  `parent_id` bigint(20) NOT NULL COMMENT '上级分类id',
                                  `create_by` bigint(20) DEFAULT NULL COMMENT '创建者',
                                  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
                                  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_catalog_tree
-- ----------------------------

-- ----------------------------
-- Table structure for p_check
-- ----------------------------
DROP TABLE IF EXISTS `p_check`;
CREATE TABLE `p_check` (
                           `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录编号',
                           `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
                           `user_id` varchar(200) NOT NULL COMMENT '巡检人id，有可能有多个以,隔开',
                           `point_id` bigint(20) NOT NULL COMMENT '巡检点id',
                           `point_name` varchar(500) DEFAULT '' COMMENT '巡检点名称',
                           `check_time` datetime DEFAULT NULL COMMENT '检查时间',
                           `upload_time` datetime DEFAULT NULL COMMENT '记录上传时间',
                           `error` varchar(1000) DEFAULT NULL COMMENT '不合格项目',
                           `device_id` varchar(100) DEFAULT NULL COMMENT '设备编号',
                           `longitude` varchar(50) DEFAULT NULL COMMENT '经度',
                           `latitude` varchar(50) DEFAULT NULL COMMENT '纬度',
                           `address` varchar(500) DEFAULT NULL COMMENT '参考地址',
                           `shot_number` int(11) NOT NULL COMMENT '拍照数量',
                           `remark` varchar(1000) DEFAULT NULL COMMENT '巡检备注说明',
                           `plan_task_id` bigint(20) DEFAULT NULL COMMENT '计划执行编号',
                           `route_id` bigint(20) DEFAULT NULL COMMENT '路线编号',
                           `route_name` varchar(500) DEFAULT '' COMMENT '线路名称',
                           `is_ok` varchar(6) DEFAULT NULL COMMENT '是否合格',
                           `score` int(11) DEFAULT NULL COMMENT '评分',
                           `plan_id` bigint(20) DEFAULT NULL COMMENT '计划编号',
                           `plan_name` varchar(500) DEFAULT '' COMMENT '计划名称',
                           `check_mode` varchar(10) DEFAULT NULL COMMENT '巡检方式',
                           `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
                           `plan_task_detail_id` bigint(20) DEFAULT NULL COMMENT '执行计划详情id',
                           `error_classify` varchar(200) DEFAULT NULL COMMENT '不合格检查项分类',
                           `user_name` varchar(200) DEFAULT '' COMMENT '执行人名称',
                           `dep_id` varchar(200) DEFAULT '' COMMENT '执行部门ids',
                           `dep_name` varchar(200) DEFAULT '' COMMENT '执行部门名称',
                           PRIMARY KEY (`id`) USING BTREE,
                           KEY `plan_task_id` (`plan_task_id`) USING BTREE,
                           KEY `user_id` (`user_id`) USING BTREE,
                           KEY `complex_id_index` (`user_id`,`point_id`,`plan_task_id`,`route_id`,`plan_id`,`plan_task_detail_id`) USING BTREE,
                           KEY `check_time_index` (`check_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2014 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_check
-- ----------------------------

-- ----------------------------
-- Table structure for p_check_input
-- ----------------------------
DROP TABLE IF EXISTS `p_check_input`;
CREATE TABLE `p_check_input` (
                                 `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '巡检记录检查项id',
                                 `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
                                 `check_id` bigint(20) NOT NULL COMMENT '巡检记录id',
                                 `input_id` bigint(20) NOT NULL COMMENT '检查项id',
                                 `order_no` int(11) NOT NULL COMMENT '序号',
                                 `input_value` varchar(1000) DEFAULT NULL COMMENT '输入值',
                                 `is_ok` varchar(6) NOT NULL COMMENT '是否合格',
                                 `score` int(11) NOT NULL COMMENT '评分',
                                 `route_point_item_id` bigint(20) DEFAULT NULL COMMENT '巡检点检查项id',
                                 `remark` varchar(500) DEFAULT NULL,
                                 `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
                                 `point_classify_id` bigint(20) DEFAULT NULL COMMENT '检查点扩展分类id',
                                 `point_classify_name` varchar(100) DEFAULT NULL COMMENT '检查点扩展分类名称',
                                 `input_name` varchar(1000) DEFAULT NULL COMMENT '检查项名称',
                                 `danger_handle_state` tinyint(4) DEFAULT NULL COMMENT '隐患处理状态 0：处理中；1：处理完成',
                                 PRIMARY KEY (`id`) USING BTREE,
                                 KEY `check_id` (`check_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2409 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_check_input
-- ----------------------------

-- ----------------------------
-- Table structure for p_check_shot
-- ----------------------------
DROP TABLE IF EXISTS `p_check_shot`;
CREATE TABLE `p_check_shot` (
                                `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录照片编号',
                                `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
                                `check_id` bigint(20) NOT NULL COMMENT '巡检记录id',
                                `check_input_id` bigint(20) DEFAULT NULL,
                                `shot_type` varchar(4) NOT NULL COMMENT '拍照类型',
                                `photo_data` text COMMENT '照片内容',
                                `point_name` varchar(100) DEFAULT NULL COMMENT '拍照点名称',
                                `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
                                `classify_id` bigint(20) DEFAULT NULL COMMENT '扩展分类id',
                                PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_check_shot
-- ----------------------------

-- ----------------------------
-- Table structure for p_config
-- ----------------------------
DROP TABLE IF EXISTS `p_config`;
CREATE TABLE `p_config` (
                            `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '配置接口id',
                            `des` varchar(50) DEFAULT NULL COMMENT '描述',
                            `name` varchar(100) NOT NULL COMMENT '名称',
                            `attribute` varchar(500) NOT NULL COMMENT '属性',
                            `create_date` datetime DEFAULT NULL COMMENT '创建时间',
                            PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_config
-- ----------------------------

-- ----------------------------
-- Table structure for p_input_item
-- ----------------------------
DROP TABLE IF EXISTS `p_input_item`;
CREATE TABLE `p_input_item` (
                                `id` bigint(20) NOT NULL AUTO_INCREMENT,
                                `org_code` varchar(100) NOT NULL COMMENT '机构编码',
                                `name` varchar(200) DEFAULT NULL COMMENT '检查项名称',
                                `order_no` int(11) DEFAULT NULL COMMENT '排序字段',
                                `item_type` varchar(50) NOT NULL COMMENT '检查项类型:文本,选择,数字',
                                `is_must` varchar(2) DEFAULT NULL COMMENT '是否必填',
                                `is_score` varchar(2) DEFAULT NULL COMMENT '是否评分',
                                `default_value` varchar(100) DEFAULT NULL COMMENT '默认值',
                                `is_multiline` varchar(2) DEFAULT NULL COMMENT '是否执行多行输入',
                                `catalog_id` bigint(20) DEFAULT NULL COMMENT '类型',
                                `input_json` longtext,
                                `data_json` longtext COMMENT '检查说明',
                                `remark` longtext COMMENT '备注',
                                `picture_json` longtext COMMENT '拍照配置',
                                `create_by` varchar(255) DEFAULT NULL COMMENT '创建者',
                                `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
                                `is_delete` bit(1) DEFAULT b'0' COMMENT '是否删除：0表示未删除，1表示已删除',
                                `level` varchar(10) DEFAULT NULL COMMENT '巡检项等级1-5',
                                `item_no` varchar(100) NOT NULL COMMENT '检查项编号',
                                `original_id` varchar(50) DEFAULT NULL COMMENT '原始字段',
                                `basis_json` text COMMENT '标准依据',
                                `risk_desc` varchar(500) DEFAULT '' COMMENT '风险描述',
                                `input_type` int(10) DEFAULT NULL COMMENT '0.表示手动录入，1.表示规则同步',
                                `input_classify` varchar(255) DEFAULT NULL COMMENT '检查点分类',
                                `equipment_name` varchar(255) DEFAULT NULL COMMENT '维保名称',
                                `title` varchar(255) DEFAULT NULL COMMENT '内容',
                                `unit` varchar(255) DEFAULT NULL COMMENT '数字项默认值单位',
                                `check_method` varchar(255) DEFAULT NULL COMMENT '检查方法',
                                `maintenance_content` varchar(255) DEFAULT NULL COMMENT '维保项内容',
                                `test_requirement` varchar(255) DEFAULT NULL COMMENT '测试要求',
                                PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=297 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_input_item
-- ----------------------------

-- ----------------------------
-- Table structure for p_latent_danger
-- ----------------------------
DROP TABLE IF EXISTS `p_latent_danger`;
CREATE TABLE `p_latent_danger` (
                                   `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键自增',
                                   `business_key` varchar(255) NOT NULL COMMENT '业务唯一标识',
                                   `org_code` varchar(255) DEFAULT NULL COMMENT '公司',
                                   `danger_name` varchar(500) NOT NULL COMMENT '隐患名称',
                                   `current_flow_record_id` bigint(20) DEFAULT NULL COMMENT '当前工作流记录编号',
                                   `instance_id` varchar(50) DEFAULT NULL COMMENT '工作流实例编号',
                                   `danger_level` tinyint(4) NOT NULL DEFAULT '1' COMMENT '隐患等级（1：一般隐患；2：重大隐患；0：安全问题）',
                                   `danger_position` varchar(255) DEFAULT NULL COMMENT '隐患地点',
                                   `danger_type` tinyint(4) NOT NULL DEFAULT '1' COMMENT '隐患类型（1：无码无计划隐患；2：巡检隐患；3：有码无计划隐患；4：随手拍）',
                                   `remark` text COMMENT '备注',
                                   `overtime_state` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否逾期（0：否；1：是）',
                                   `reform_type` tinyint(4) DEFAULT NULL COMMENT '整改类型（1：常规整改；2：安措计划；3：延期治理）',
                                   `reform_limit_date` datetime DEFAULT NULL COMMENT '整改限制时间',
                                   `reform_json` text COMMENT '整改对象',
                                   `danger_state` tinyint(4) NOT NULL DEFAULT '1' COMMENT '隐患状态（1：待评审；2：待治理；3：安措计划中；4：待验证；5：治理完毕；6：已撤销；7：延期治理中；8：延期治理待车间部门审核；9：延期治理待公司审核',
                                   `discoverer_user_id` varchar(255) NOT NULL COMMENT '发现人',
                                   `discoverer_department_id` varchar(255) DEFAULT NULL COMMENT '发现人部门编号',
                                   `photo_urls` text COMMENT '图片',
                                   `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否删除（0：否；1：是）',
                                   `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '记录创建时间',
                                   `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '记录修改时间',
                                   `delay_limit_date` datetime DEFAULT NULL COMMENT '延期治理时间',
                                   `problem_description` varchar(500) DEFAULT NULL COMMENT '问题描述',
                                   `reason_analysis` varchar(500) DEFAULT NULL COMMENT '原因分析',
                                   `infer_other_things` varchar(500) DEFAULT NULL COMMENT '举一反三',
                                   `check_input_id` bigint(20) DEFAULT NULL COMMENT '检查记录创建隐患对应check_input_id',
                                   `structure_id` bigint(20) DEFAULT NULL COMMENT '建筑ID',
                                   `structure_name` varchar(255) DEFAULT NULL COMMENT '建筑名称',
                                   `instance_key` varchar(255) DEFAULT NULL COMMENT '流程实例key',
                                   PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8 COMMENT='隐患表';

-- ----------------------------
-- Records of p_latent_danger
-- ----------------------------

-- ----------------------------
-- Table structure for p_latent_danger_flow_record
-- ----------------------------
DROP TABLE IF EXISTS `p_latent_danger_flow_record`;
CREATE TABLE `p_latent_danger_flow_record` (
                                               `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键自增',
                                               `danger_id` bigint(20) NOT NULL COMMENT '隐患编号',
                                               `action_flag` varchar(50) NOT NULL COMMENT '执行标志',
                                               `flow_task_name` varchar(255) DEFAULT NULL COMMENT '当前节点名称',
                                               `flow_task_user_ids` text COMMENT '当前节点可执行人（多个逗号分开）',
                                               `flow_task_id` varchar(255) DEFAULT NULL COMMENT '当前节点编号',
                                               `excute_state` tinyint(4) NOT NULL DEFAULT '1' COMMENT '执行状态（1：未执行；2：通过；3：驳回）',
                                               `excute_user_id` varchar(255) DEFAULT NULL COMMENT '执行人',
                                               `excute_department_id` varchar(255) DEFAULT NULL COMMENT '执行部门编号',
                                               `excute_result` varchar(255) DEFAULT NULL COMMENT '执行结果',
                                               `remark` text COMMENT '备注',
                                               `flow_json` text COMMENT '上传数据',
                                               `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否删除（0：否；1：是）',
                                               `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '记录创建时间',
                                               `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '记录修改时间',
                                               PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8 COMMENT='隐患工作流记录表';

-- ----------------------------
-- Records of p_latent_danger_flow_record
-- ----------------------------

-- ----------------------------
-- Table structure for p_latent_danger_patrol
-- ----------------------------
DROP TABLE IF EXISTS `p_latent_danger_patrol`;
CREATE TABLE `p_latent_danger_patrol` (
                                          `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键自增',
                                          `latent_danger_id` bigint(20) DEFAULT NULL COMMENT '隐患编号',
                                          `point_classify_id` bigint(20) DEFAULT NULL COMMENT '巡检项分类编号',
                                          `check_id` bigint(20) DEFAULT NULL COMMENT '检查记录编号',
                                          `item_id` bigint(20) DEFAULT NULL COMMENT '巡检项编号',
                                          `risk_factor_flow_id` varchar(255) DEFAULT NULL COMMENT '风险因素工作流编号',
                                          `point_id` bigint(20) DEFAULT NULL COMMENT '巡检点编号',
                                          `route_id` bigint(20) DEFAULT NULL COMMENT '巡检路线编号',
                                          `route_point_item_id` bigint(20) DEFAULT NULL COMMENT '路线、点、检查项关联编号',
                                          `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否删除（0：否；1：是）',
                                          `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '记录创建时间',
                                          `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '记录修改时间',
                                          PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COMMENT='隐患巡检关系表';

-- ----------------------------
-- Records of p_latent_danger_patrol
-- ----------------------------

-- ----------------------------
-- Table structure for p_latent_danger_photo
-- ----------------------------
DROP TABLE IF EXISTS `p_latent_danger_photo`;
CREATE TABLE `p_latent_danger_photo` (
                                         `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键自增',
                                         `biz_code` varchar(255) DEFAULT NULL COMMENT '类型编码',
                                         `url` varchar(500) DEFAULT NULL COMMENT '图片路径',
                                         `biz_id` bigint(20) DEFAULT NULL COMMENT '业务编号',
                                         `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否删除（0：否；1：是）',
                                         `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '记录创建时间',
                                         `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '记录修改时间',
                                         PRIMARY KEY (`id`) USING BTREE,
                                         KEY `index_latent_danger_id` (`biz_id`) USING BTREE COMMENT '隐患编号索引'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='隐患图片';

-- ----------------------------
-- Records of p_latent_danger_photo
-- ----------------------------

-- ----------------------------
-- Table structure for p_measures
-- ----------------------------
DROP TABLE IF EXISTS `p_measures`;
CREATE TABLE `p_measures` (
                              `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '管控措施编号',
                              `level` varchar(10) DEFAULT NULL COMMENT '风险等级',
                              `accident_type` text COMMENT '事故类型',
                              `point_id` bigint(20) DEFAULT NULL COMMENT '风险点id',
                              `update_by` varchar(255) DEFAULT NULL COMMENT '更新用户id',
                              `update_time` datetime DEFAULT NULL COMMENT '更新时间',
                              `engineering` text COMMENT '工程措施',
                              `management` text COMMENT '管理措施',
                              `train` text COMMENT '培训教育',
                              `protection` text COMMENT '个体防护',
                              `disposal` text COMMENT '应急处置',
                              `is_del` int(11) DEFAULT '0' COMMENT '是否删除',
                              `risk_factors` text COMMENT '风险因素',
                              `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
                              PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_measures
-- ----------------------------

-- ----------------------------
-- Table structure for p_msg
-- ----------------------------
DROP TABLE IF EXISTS `p_msg`;
CREATE TABLE `p_msg` (
                         `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
                         `org_code` varchar(100) NOT NULL COMMENT '公司orgCode',
                         `title` varchar(255) NOT NULL COMMENT '消息标题',
                         `body` text NOT NULL COMMENT '内容',
                         `msg_type` varchar(255) NOT NULL COMMENT '消息类型',
                         `status` int(4) DEFAULT NULL COMMENT '发送状态',
                         `send_time` datetime DEFAULT NULL COMMENT '发送时间',
                         `relation_id` bigint(20) DEFAULT NULL COMMENT '关联id',
                         `is_immediately` bit(1) DEFAULT b'1' COMMENT '是否立即发送',
                         `fixed_time` datetime DEFAULT NULL COMMENT '定点发送时间',
                         `create_by` varchar(255) DEFAULT NULL COMMENT '创建者',
                         `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
                         `is_read` bit(1) DEFAULT b'0' COMMENT '是否已读',
                         `target_tel` varchar(500) DEFAULT NULL,
                         `reciver_name` varchar(255) DEFAULT NULL COMMENT '接受人名称',
                         `user_id` varchar(255) DEFAULT NULL COMMENT '接收人id',
                         PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=495 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_msg
-- ----------------------------

-- ----------------------------
-- Table structure for p_msg_subscribe
-- ----------------------------
DROP TABLE IF EXISTS `p_msg_subscribe`;
CREATE TABLE `p_msg_subscribe` (
                                   `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
                                   `org_code` varchar(50) NOT NULL COMMENT '公司code',
                                   `user_id` varchar(255) NOT NULL COMMENT '用户ID',
                                   `msg_type` varchar(255) NOT NULL COMMENT '消息类型',
                                   `attribute1` varchar(255) DEFAULT NULL COMMENT '属性1',
                                   `attribute2` varchar(255) DEFAULT NULL COMMENT '属性2',
                                   `attribute3` varchar(255) DEFAULT NULL COMMENT '属性3',
                                   `attribute4` varchar(255) DEFAULT NULL COMMENT '属性4',
                                   `attribute5` varchar(255) DEFAULT NULL COMMENT '属性5',
                                   `create_date` datetime DEFAULT NULL COMMENT '创建时间',
                                   PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_msg_subscribe
-- ----------------------------

-- ----------------------------
-- Table structure for p_plan
-- ----------------------------
DROP TABLE IF EXISTS `p_plan`;
CREATE TABLE `p_plan` (
                          `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '计划编号',
                          `name` varchar(100) NOT NULL COMMENT '计划名称',
                          `org_code` varchar(100) NOT NULL COMMENT '公司Id',
                          `dept_id` varchar(225) DEFAULT NULL COMMENT '部门id',
                          `route_id` bigint(20) NOT NULL COMMENT '路线编号',
                          `plan_type` varchar(50) NOT NULL COMMENT '计划类型：1-日，2-周，3-月，4-年',
                          `is_fixed_date` varchar(2) NOT NULL COMMENT '是否固定巡检日期：0-否；1-是',
                          `in_order` varchar(2) DEFAULT '0' COMMENT '是否必须按照顺序执行：0-否；1-是',
                          `plan_begin` date DEFAULT NULL COMMENT '计划开始日期',
                          `plan_end` date DEFAULT NULL COMMENT '计划结束日期',
                          `day_rate` int(11) DEFAULT NULL COMMENT '每天频率：0-一次；1-多次',
                          `day_time` time DEFAULT NULL COMMENT '开始时间（执行频率为一次时，使用）',
                          `day_interval` int(11) DEFAULT NULL COMMENT '执行间隔（每天执行频率为多次时使用）',
                          `day_interval_unit` varchar(50) DEFAULT NULL COMMENT '执行间隔单位：1-小时，2-分钟，3-秒',
                          `day_begin` time DEFAULT NULL COMMENT '开始时间',
                          `day_end` time DEFAULT NULL COMMENT '结束时间',
                          `execute_interval` int(11) DEFAULT NULL COMMENT '执行间隔',
                          `month_type` varchar(50) DEFAULT NULL COMMENT '月执行类型：1-第，2-在',
                          `what_day` varchar(50) DEFAULT NULL COMMENT '哪一天',
                          `what_week` int(11) DEFAULT NULL COMMENT '第几周',
                          `week_day` int(11) DEFAULT NULL COMMENT '周几',
                          `duration` int(11) DEFAULT NULL COMMENT '工作时长（分钟）',
                          `user_id` text COMMENT '用户编号',
                          `user_name` text COMMENT '用户名称',
                          `execute_rate` int(11) DEFAULT NULL COMMENT '执行频率（年计划使用）',
                          `week_begin_num` int(11) DEFAULT NULL COMMENT '开始编号',
                          `week_end_num` int(11) DEFAULT NULL COMMENT '结束编号',
                          `min_space` int(11) DEFAULT NULL COMMENT '最少间隔',
                          `is_score` varchar(2) DEFAULT NULL COMMENT '是否评分',
                          `score_formula` varchar(512) DEFAULT NULL COMMENT '评分计算公式',
                          `status` tinyint(4) DEFAULT '0' COMMENT '状态:0-正常；1-已停用',
                          `error` bigint(10) DEFAULT '0' COMMENT '允许误差(分钟)',
                          `next_gen_date` date DEFAULT NULL COMMENT '下次任务生成日期',
                          `create_by` int(11) DEFAULT NULL COMMENT '创建者',
                          `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
                          `last_upd_by` int(11) DEFAULT NULL COMMENT '最近更新者',
                          `last_upd_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '最近更新时间',
                          `remark` varchar(255) DEFAULT NULL COMMENT '备注',
                          `remark1` varchar(255) DEFAULT NULL COMMENT '备注1',
                          `remark2` varchar(255) DEFAULT NULL COMMENT '备注2',
                          `first_flag` int(4) DEFAULT '0' COMMENT '初始状态标识：0-首次 1-其他',
                          `is_delete` bit(1) DEFAULT b'0' COMMENT '是否删除：0表示未删除，1表示已删除',
                          `original_id` varchar(50) DEFAULT NULL COMMENT '原始字段',
                          `plan_task_id` bigint(20) DEFAULT '0' COMMENT '最新任务id',
                          `is_single_execution` bit(1) DEFAULT b'0' COMMENT '是否单人执行:0多人执行；1单人执行',
                          `user_dept` text COMMENT '冗余用户部门',
                          PRIMARY KEY (`id`) USING BTREE,
                          KEY `idx_org_code_route_id` (`org_code`,`route_id`) USING BTREE,
                          KEY `idx_is_stop_next_gen_date` (`status`,`next_gen_date`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_plan
-- ----------------------------

-- ----------------------------
-- Table structure for p_plan_exec_statistics
-- ----------------------------
DROP TABLE IF EXISTS `p_plan_exec_statistics`;
CREATE TABLE `p_plan_exec_statistics` (
                                          `id` bigint(11) NOT NULL AUTO_INCREMENT,
                                          `check_time` varchar(40) NOT NULL COMMENT '巡检日期',
                                          `org_code` varchar(255) NOT NULL COMMENT '计划任务执行人orgCode',
                                          `user_id` varchar(50) NOT NULL COMMENT '用户ID',
                                          `plan_task_num` int(11) DEFAULT NULL COMMENT '计划执行个数',
                                          `exec_plan_task_num` int(11) DEFAULT '0' COMMENT '计划执行完成个数',
                                          `missed_check_num` int(11) DEFAULT '0' COMMENT '漏检个数',
                                          `outside_plan_num` int(11) DEFAULT '0' COMMENT '计划外执行个数',
                                          PRIMARY KEY (`id`,`org_code`,`user_id`,`check_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_plan_exec_statistics
-- ----------------------------

-- ----------------------------
-- Table structure for p_plan_task
-- ----------------------------
DROP TABLE IF EXISTS `p_plan_task`;
CREATE TABLE `p_plan_task` (
                               `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '批次号',
                               `batch_no` bigint(20) NOT NULL COMMENT '计划批次号',
                               `org_code` varchar(255) DEFAULT NULL COMMENT '计划任务执行人orgCode',
                               `plan_id` bigint(20) NOT NULL COMMENT '计划编号',
                               `route_id` bigint(20) DEFAULT NULL COMMENT '路线编号',
                               `user_id` varchar(500) DEFAULT NULL COMMENT '用户编号',
                               `point_num` int(11) DEFAULT NULL COMMENT '巡检点数',
                               `finish_num` int(11) DEFAULT '0' COMMENT '已完成巡检点数',
                               `check_date` date DEFAULT NULL COMMENT '巡检日期',
                               `begin_time` datetime DEFAULT NULL COMMENT '开始时间',
                               `end_time` datetime DEFAULT NULL COMMENT '结束时间',
                               `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
                               `finish_status` int(4) DEFAULT '0' COMMENT '完成状态：0-未开始；1-进行中;2-已结束；3-已超时',
                               `status` int(4) DEFAULT '0' COMMENT '状态：0-有效；1-无效',
                               `in_order` varchar(2) DEFAULT '0' COMMENT '是否必须按照顺序执行：0-否；1-是',
                               `user_dept` varchar(255) DEFAULT NULL COMMENT '人员部门信息',
                               `user_name` varchar(255) DEFAULT NULL COMMENT '用户姓名',
                               PRIMARY KEY (`id`) USING BTREE,
                               KEY `plan_id` (`plan_id`) USING BTREE,
                               KEY `begin_time` (`begin_time`) USING BTREE,
                               KEY `end_time` (`end_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2947 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_plan_task
-- ----------------------------

-- ----------------------------
-- Table structure for p_plan_task_detail
-- ----------------------------
DROP TABLE IF EXISTS `p_plan_task_detail`;
CREATE TABLE `p_plan_task_detail` (
                                      `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '任务明细编号',
                                      `task_no` bigint(20) NOT NULL COMMENT '批次号',
                                      `point_id` bigint(20) NOT NULL COMMENT '点编号',
                                      `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
                                      `is_finish` int(11) DEFAULT '0' COMMENT '是否完成：0-未完成，1-已完成，2-超时漏检',
                                      `status` varchar(50) DEFAULT '合格' COMMENT '状态',
                                      `executor_id` bigint(20) DEFAULT '0' COMMENT '执行人id',
                                      `executor_date` datetime DEFAULT NULL COMMENT '执行时间',
                                      PRIMARY KEY (`id`) USING BTREE,
                                      KEY `task_no` (`task_no`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3622 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_plan_task_detail
-- ----------------------------

-- ----------------------------
-- Table structure for p_point
-- ----------------------------
DROP TABLE IF EXISTS `p_point`;
CREATE TABLE `p_point` (
                           `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '点id',
                           `route_id` varchar(1000) DEFAULT NULL COMMENT '路线id',
                           `route_name` varchar(1000) DEFAULT NULL COMMENT '路线名称',
                           `name` varchar(100) NOT NULL COMMENT '点名称',
                           `point_no` varchar(100) NOT NULL DEFAULT '0' COMMENT '编号',
                           `remark` varchar(1000) DEFAULT NULL COMMENT '备注说明',
                           `save_gps` varchar(10) DEFAULT NULL COMMENT '是否保存地理信',
                           `distance` int(11) DEFAULT NULL COMMENT '有效巡检距离',
                           `usually_shot` varchar(10) DEFAULT NULL COMMENT '是否允许普通拍照',
                           `shot_min_number` int(11) NOT NULL COMMENT '最小拍照数',
                           `shot_max_number` int(11) NOT NULL COMMENT '最大拍照数',
                           `fixed_shot` int(11) NOT NULL COMMENT '定点拍照数',
                           `latitude` varchar(50) DEFAULT NULL COMMENT '经度',
                           `longitude` varchar(50) DEFAULT NULL COMMENT '纬度',
                           `address` varchar(1000) DEFAULT NULL COMMENT '参考地址',
                           `offline` bit(1) DEFAULT NULL COMMENT '是否允许离线巡检:0不支持1支持',
                           `is_fixed` varchar(50) DEFAULT NULL COMMENT '是否为固定',
                           `catalog_id` int(11) DEFAULT NULL COMMENT '分类编号',
                           `extend_json` longtext COMMENT '扩展字段',
                           `is_score` varchar(50) DEFAULT NULL COMMENT '无计划巡检是否评分',
                           `level` varchar(100) NOT NULL DEFAULT '1' COMMENT '风险等级',
                           `last_update_time` datetime DEFAULT NULL COMMENT '最新更新时间',
                           `creator_id` varchar(255) NOT NULL COMMENT '创建用户id',
                           `create_date` datetime DEFAULT NULL COMMENT '创建时间',
                           `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
                           `coordinates` varchar(100) DEFAULT NULL COMMENT '3维坐标',
                           `ue4_location` text COMMENT 'ue4旋转',
                           `ue4_rotation` text COMMENT 'ue4旋转',
                           `is_delete` bit(1) DEFAULT b'0' COMMENT '是否删除：0表示未删除，1表示已删除',
                           `charge_dept_id` varchar(255) DEFAULT '0' COMMENT '责任部门id',
                           `charge_person_id` varchar(255) DEFAULT NULL COMMENT '负责人id',
                           `status` varchar(50) DEFAULT '0' COMMENT '状态：0 未纳入巡检，1 合格；2 不合格；3 漏检',
                           `floor` int(4) DEFAULT '1' COMMENT '3维模型楼层',
                           `error` varchar(1000) DEFAULT NULL COMMENT '最新不合格信息',
                           `check_time` datetime DEFAULT NULL COMMENT '最新检查时间',
                           `is_indoor` bit(1) DEFAULT b'0' COMMENT '是否室内：0表示室外，1表示室内',
                           `original_id` varchar(50) DEFAULT NULL COMMENT '原始字段',
                           `last_check_id` varchar(32) DEFAULT NULL COMMENT '最近检查记录（漏检不算）',
                           `risk_source_id` varchar(255) DEFAULT NULL COMMENT '风险区域id',
                           `area_id` bigint(20) DEFAULT NULL COMMENT '物理区域id（数据来源于装备wl_area）',
                           `area_name` varchar(255) DEFAULT NULL COMMENT '物理区域名称（数据来源于装备wl_area）',
                           `equipment_id` varchar(32) DEFAULT NULL COMMENT '装备定义id',
                           `equipment_name` varchar(255) DEFAULT NULL COMMENT '装备定义名称（冗余字段）',
                           `belong_system_id` varchar(32) DEFAULT NULL COMMENT '所属消防系统id',
                           `belong_system_name` varchar(255) DEFAULT NULL COMMENT '所属消防系统名称（冗余字段)',
                           `owner_id` varchar(50) DEFAULT NULL COMMENT '业主单位',
                           `owner_name` varchar(255) DEFAULT NULL COMMENT '业主单位名称(冗余列表使用)',
                           PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=195 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_point
-- ----------------------------

-- ----------------------------
-- Table structure for p_point_classify
-- ----------------------------
DROP TABLE IF EXISTS `p_point_classify`;
CREATE TABLE `p_point_classify` (
                                    `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '巡检点分类id',
                                    `point_id` bigint(20) NOT NULL COMMENT '点id',
                                    `name` varchar(100) NOT NULL COMMENT '点分类名称',
                                    `creator_id` varchar(255) NOT NULL COMMENT '创建人id',
                                    `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
                                    `order_no` int(11) DEFAULT NULL COMMENT '排序号',
                                    `original_id` varchar(50) DEFAULT NULL COMMENT '原始字段',
                                    `equipment_id` varchar(255) DEFAULT NULL COMMENT '装备id',
                                    `inspection_spec_name` varchar(255) DEFAULT NULL COMMENT '巡查规范名称',
                                    PRIMARY KEY (`id`) USING BTREE,
                                    KEY `point_id_index` (`point_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_point_classify
-- ----------------------------

-- ----------------------------
-- Table structure for p_point_config
-- ----------------------------
DROP TABLE IF EXISTS `p_point_config`;
CREATE TABLE `p_point_config` (
                                  `id` bigint(20) NOT NULL AUTO_INCREMENT,
                                  `name` varchar(1000) DEFAULT NULL COMMENT '转发名称',
                                  `point_id` bigint(20) DEFAULT NULL COMMENT '巡检点ID',
                                  `point_code` varchar(255) DEFAULT NULL COMMENT '点编码',
                                  `infomation_address` int(20) DEFAULT NULL COMMENT '转发信息地址依次递增（唯一）',
                                  `status` bit(1) DEFAULT NULL COMMENT '巡检点状态（code=0时，status=1漏检，status=0正常；code=1时，status=1不合格，status=0合格）',
                                  `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
                                  `is_delete` bit(1) DEFAULT b'0' COMMENT '是否已经删除',
                                  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=917 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_point_config
-- ----------------------------

-- ----------------------------
-- Table structure for p_point_inputitem
-- ----------------------------
DROP TABLE IF EXISTS `p_point_inputitem`;
CREATE TABLE `p_point_inputitem` (
                                     `id` bigint(20) NOT NULL AUTO_INCREMENT,
                                     `point_id` bigint(20) NOT NULL COMMENT '巡检点id',
                                     `input_item_id` bigint(20) NOT NULL COMMENT '巡检项id',
                                     `classify_ids` varchar(255) DEFAULT NULL COMMENT '点分类id集合',
                                     `order_no` int(11) DEFAULT NULL COMMENT '排序号',
                                     `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
                                     PRIMARY KEY (`id`) USING BTREE,
                                     KEY `point_id_index` (`point_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_point_inputitem
-- ----------------------------

-- ----------------------------
-- Table structure for p_point_photo
-- ----------------------------
DROP TABLE IF EXISTS `p_point_photo`;
CREATE TABLE `p_point_photo` (
                                 `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '巡检点图片编号',
                                 `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
                                 `point_id` bigint(20) NOT NULL COMMENT '巡检点id',
                                 `order_no` int(11) NOT NULL COMMENT '序号',
                                 `photo_path` varchar(200) DEFAULT NULL COMMENT '图片路径',
                                 `file_name` varchar(200) DEFAULT NULL COMMENT '图片名称',
                                 `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
                                 PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_point_photo
-- ----------------------------

-- ----------------------------
-- Table structure for p_route
-- ----------------------------
DROP TABLE IF EXISTS `p_route`;
CREATE TABLE `p_route` (
                           `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '巡检路线id',
                           `creator_id` varchar(255) NOT NULL COMMENT '创建人id',
                           `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
                           `owner_id` varchar(50) DEFAULT NULL COMMENT '业主单位',
                           `owner_name` varchar(255) DEFAULT NULL COMMENT '业主单位名称(冗余列表使用)',
                           `name` varchar(50) NOT NULL COMMENT '路线名称',
                           `boss` varchar(32) DEFAULT NULL COMMENT '负责人id',
                           `boss_name` varchar(255) DEFAULT NULL COMMENT '负责人名称（冗余字段）',
                           `tel` varchar(50) DEFAULT NULL COMMENT '联系电话',
                           `remark` varchar(1000) DEFAULT NULL COMMENT '备注说明',
                           `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
                           `coordinates` varchar(500) DEFAULT NULL COMMENT '路线3维坐标',
                           `is_delete` bit(1) DEFAULT b'0' COMMENT '是否删除：0表示未删除，1表示已删除',
                           `dept_id` varchar(255) DEFAULT '0',
                           `user_id` varchar(255) DEFAULT '0',
                           `original_id` varchar(50) DEFAULT NULL COMMENT '原始字段',
                           PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_route
-- ----------------------------

-- ----------------------------
-- Table structure for p_route_point
-- ----------------------------
DROP TABLE IF EXISTS `p_route_point`;
CREATE TABLE `p_route_point` (
                                 `id` bigint(20) NOT NULL AUTO_INCREMENT,
                                 `org_code` varchar(100) NOT NULL COMMENT '权限org code',
                                 `route_id` bigint(20) NOT NULL COMMENT '路线id',
                                 `point_id` bigint(20) NOT NULL COMMENT '点id',
                                 `order_no` int(11) DEFAULT '0' COMMENT '排序',
                                 `creator_id` varchar(255) NOT NULL COMMENT '创建人id',
                                 `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
                                 `exclude_items` varchar(1000) DEFAULT NULL COMMENT '巡查项排除',
                                 PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_route_point
-- ----------------------------

-- ----------------------------
-- Table structure for p_route_point_item
-- ----------------------------
DROP TABLE IF EXISTS `p_route_point_item`;
CREATE TABLE `p_route_point_item` (
                                      `id` bigint(20) NOT NULL AUTO_INCREMENT,
                                      `route_point_id` bigint(20) NOT NULL COMMENT '路线点id',
                                      `order_no` int(11) DEFAULT NULL COMMENT '排序号',
                                      `point_input_item_id` bigint(20) DEFAULT NULL COMMENT '检查点-项id',
                                      `creator_id` varchar(255) DEFAULT NULL,
                                      `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
                                      `point_classify_id` bigint(20) DEFAULT NULL COMMENT '检查点扩展分类id',
                                      `basis_json` text COMMENT '标准依据',
                                      PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=83 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_route_point_item
-- ----------------------------

-- ----------------------------
-- Table structure for p_task
-- ----------------------------
DROP TABLE IF EXISTS `p_task`;
CREATE TABLE `p_task` (
                          `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
                          `org_code` varchar(100) DEFAULT NULL COMMENT '公司id',
                          `title` varchar(500) DEFAULT NULL COMMENT '任务标题',
                          `publisher` varchar(255) DEFAULT NULL COMMENT '任务发布人id',
                          `dep_id` varchar(255) DEFAULT NULL COMMENT '执行人部门',
                          `publisher_name` varchar(40) DEFAULT NULL COMMENT '任务发布人名称',
                          `publish_time` datetime DEFAULT NULL COMMENT '任务发布时间',
                          `finish_time` datetime DEFAULT NULL COMMENT '任务应该完成时间',
                          `fact_finish_time` datetime DEFAULT NULL COMMENT '任务实际完成时间',
                          `is_warn` varchar(50) DEFAULT NULL COMMENT '是否告警通知（1 通知 ； 2 不通知 ）',
                          `status` int(11) DEFAULT NULL COMMENT '任务状态0 处理中，1已完成2取消3超时',
                          `warn_time` datetime DEFAULT NULL COMMENT '告警通知时间',
                          `feedback_num` int(11) DEFAULT NULL COMMENT '回复个数',
                          `executor` varchar(2000) DEFAULT NULL COMMENT '任务执行人',
                          `depth` int(11) DEFAULT NULL COMMENT '当前任务发转次数',
                          `max_depth` int(11) DEFAULT NULL COMMENT '任务最大转发次数',
                          `remark` varchar(1000) DEFAULT NULL COMMENT '说明',
                          `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
                          `config` longtext COMMENT '任务拍照配置',
                          `executor_id` varchar(255) NOT NULL,
                          `check_id` bigint(20) DEFAULT '0' COMMENT '任务关联检查项ID',
                          `point_id` bigint(11) DEFAULT '0' COMMENT '任务关联巡检点id',
                          PRIMARY KEY (`id`) USING BTREE,
                          KEY `check_id_index` (`check_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_task
-- ----------------------------

-- ----------------------------
-- Table structure for p_task_detail
-- ----------------------------
DROP TABLE IF EXISTS `p_task_detail`;
CREATE TABLE `p_task_detail` (
                                 `id` bigint(20) NOT NULL AUTO_INCREMENT,
                                 `task_id` bigint(20) DEFAULT NULL COMMENT '任务id',
                                 `item_id` bigint(20) DEFAULT NULL COMMENT '检查项ID',
                                 `check_id` bigint(20) DEFAULT NULL COMMENT '检查记录id',
                                 `status` int(11) DEFAULT NULL COMMENT '任务相状态（1.完成，2.未完成，3.执行中）',
                                 `remark` varchar(1000) DEFAULT NULL COMMENT '描述说明',
                                 `point_id` bigint(20) DEFAULT NULL COMMENT '巡检点ID',
                                 `route_id` bigint(20) DEFAULT NULL COMMENT '路线ID',
                                 `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
                                 PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_task_detail
-- ----------------------------

-- ----------------------------
-- Table structure for p_task_feedback
-- ----------------------------
DROP TABLE IF EXISTS `p_task_feedback`;
CREATE TABLE `p_task_feedback` (
                                   `id` bigint(20) NOT NULL AUTO_INCREMENT,
                                   `org_code` varchar(100) NOT NULL COMMENT '组织编码',
                                   `task_id` bigint(20) NOT NULL COMMENT '任务ID',
                                   `user_id` varchar(255) NOT NULL COMMENT '任务回复人ID',
                                   `user_name` varchar(50) NOT NULL COMMENT '任务回复人名称',
                                   `feedback_time` datetime NOT NULL COMMENT '回复时间',
                                   `message` text COMMENT '任务回复信息',
                                   `picture_number` int(11) DEFAULT NULL COMMENT '拍照个数',
                                   `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
                                   `message_type` varchar(20) DEFAULT NULL COMMENT '任务类型',
                                   PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_task_feedback
-- ----------------------------

-- ----------------------------
-- Table structure for p_task_forward_log
-- ----------------------------
DROP TABLE IF EXISTS `p_task_forward_log`;
CREATE TABLE `p_task_forward_log` (
                                      `id` bigint(20) NOT NULL AUTO_INCREMENT,
                                      `task_id` bigint(20) DEFAULT NULL COMMENT '任务ID',
                                      `executor` varchar(255) DEFAULT NULL COMMENT '任务执行人',
                                      `executor_id` varchar(255) DEFAULT NULL,
                                      `created_by` bigint(20) DEFAULT NULL COMMENT '记录创建者',
                                      `content` varchar(2000) DEFAULT NULL COMMENT '任务转发记录详情',
                                      `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
                                      PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_task_forward_log
-- ----------------------------

-- ----------------------------
-- Table structure for p_task_picture
-- ----------------------------
DROP TABLE IF EXISTS `p_task_picture`;
CREATE TABLE `p_task_picture` (
                                  `id` bigint(20) NOT NULL AUTO_INCREMENT,
                                  `org_code` varchar(100) NOT NULL COMMENT '组织编码',
                                  `task_id` bigint(20) NOT NULL COMMENT '任务ID',
                                  `feedback_id` bigint(20) NOT NULL COMMENT '任务回复ID',
                                  `photo_data` longtext NOT NULL COMMENT '回复照片',
                                  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
                                  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_task_picture
-- ----------------------------

-- ----------------------------
-- View structure for get_danger_count
-- ----------------------------
DROP VIEW IF EXISTS `get_danger_count`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `get_danger_count` AS select '计划巡查' AS `name`,count(1) AS `value` from `p_latent_danger` where (`p_latent_danger`.`danger_type` = 2) union select '无计划检查' AS `name`,count(1) AS `value` from `p_latent_danger` where (`p_latent_danger`.`danger_type` = 3) union select '无码检查' AS `name`,count(1) AS `value` from `p_latent_danger` where (`p_latent_danger`.`danger_type` = 1) union select '随手拍' AS `name`,count(1) AS `value` from `p_latent_danger` where (`p_latent_danger`.`danger_type` = 4) ;

-- ----------------------------
-- View structure for get_dev_mom
-- ----------------------------
DROP VIEW IF EXISTS `get_dev_mom`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `get_dev_mom` AS select `abc`.`today` AS `today`,if((isnull(`abc`.`mom`) or (`abc`.`mom` = 0)),'--',concat(`abc`.`mom`,'%')) AS `mom`,if((isnull(`abc`.`mom`) or (`abc`.`mom` = 0)),0,`abc`.`flag`) AS `flag` from (select `to`.`c` AS `today`,if(((`ye`.`c` = 0) or (`ye`.`c` = `to`.`c`)),0,abs(round((((`to`.`c` - `ye`.`c`) / `ye`.`c`) * 100),0))) AS `mom`,if(((`ye`.`c` = 0) or (`to`.`c` = `ye`.`c`)),0,if((`to`.`c` > `ye`.`c`),1,2)) AS `flag` from (((select count(1) AS `c` from `p_plan_task_detail` where ((`p_plan_task_detail`.`status` = 2) or ((`p_plan_task_detail`.`status` = 3) and (`p_plan_task_detail`.`create_date` like concat(curdate(),'%')))))) `to` join (select count(1) AS `c` from `p_plan_task_detail` where ((`p_plan_task_detail`.`status` = 2) or ((`p_plan_task_detail`.`status` = 3) and (`p_plan_task_detail`.`create_date` like concat((curdate() - interval 1 day),'%'))))) `ye`)) `abc` ;

-- ----------------------------
-- View structure for s_danger_govern_count
-- ----------------------------
DROP VIEW IF EXISTS `s_danger_govern_count`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `s_danger_govern_count` AS select count(distinct `ld`.`id`) AS `danger_govern_count`,cast(now() as date) AS `vest_date` from (`p_latent_danger` `ld` left join `p_latent_danger_flow_record` `ldfr` on((`ldfr`.`danger_id` = `ld`.`id`))) where ((`ld`.`org_code` = '10') and (`ld`.`danger_state` = '5') and (cast(`ldfr`.`create_date` as date) = cast(now() as date))) ;

-- ----------------------------
-- View structure for s_patrol_plan_exec_day
-- ----------------------------
DROP VIEW IF EXISTS `s_patrol_plan_exec_day`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `s_patrol_plan_exec_day` AS select count(`td`.`point_id`) AS `plan_task_num`,ifnull(sum((case when (`td`.`is_finish` = 0) then 1 else 0 end)),0) AS `unfinished_count`,ifnull(sum((case when (`td`.`is_finish` = 1) then 1 else 0 end)),0) AS `exec_plan_task_num`,ifnull(sum((case when (`td`.`is_finish` = 2) then 1 else 0 end)),0) AS `missed_check_num`,`p`.`org_code` AS `org_code`,cast(now() as date) AS `vest_date` from (`p_plan_task_detail` `td` left join `p_point` `p` on((`p`.`id` = `td`.`point_id`))) where (cast(`td`.`create_date` as date) = cast(now() as date)) ;

-- ----------------------------
-- View structure for s_patrol_plan_exec_week
-- ----------------------------
DROP VIEW IF EXISTS `s_patrol_plan_exec_week`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `s_patrol_plan_exec_week` AS select count(`td`.`point_id`) AS `plan_task_num`,ifnull(sum((case when (`td`.`is_finish` = 0) then 1 else 0 end)),0) AS `unfinished_count`,ifnull(sum((case when (`td`.`is_finish` = 1) then 1 else 0 end)),0) AS `exec_plan_task_num`,ifnull(sum((case when (`td`.`is_finish` = 2) then 1 else 0 end)),0) AS `missed_check_num`,`p`.`org_code` AS `org_code`,week(now(),0) AS `week`,year(now()) AS `year` from (`p_plan_task_detail` `td` left join `p_point` `p` on((`p`.`id` = `td`.`point_id`))) where ((week(`td`.`create_date`,0) = week(now(),0)) and (year(`td`.`create_date`) = year(now()))) ;

-- ----------------------------
-- View structure for s_patrol_plan_task_exec_day
-- ----------------------------
DROP VIEW IF EXISTS `s_patrol_plan_task_exec_day`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `s_patrol_plan_task_exec_day` AS select count(`pt`.`id`) AS `plan_task_num`,ifnull(sum((case when ((`pt`.`finish_status` = 0) or (`pt`.`finish_status` = 1)) then 1 else 0 end)),0) AS `unfinished_count`,ifnull(sum((case when (`pt`.`finish_status` = 2) then 1 else 0 end)),0) AS `exec_plan_task_num`,ifnull(sum((case when (`pt`.`finish_status` = 3) then 1 else 0 end)),0) AS `missed_check_num`,ifnull((select count(1) AS `input_abnormal_count` from `p_check` where ((`p_check`.`is_ok` = 2) and ((to_days(now()) - to_days(`p_check`.`check_time`)) = 0))),0) AS `input_abnormal_count`,cast(now() as date) AS `vest_date` from `p_plan_task` `pt` where (((to_days(`pt`.`begin_time`) - to_days(now())) = 0) and ((to_days(now()) - to_days(`pt`.`end_time`)) = 0)) ;

-- ----------------------------
-- View structure for s_risk_danger_day
-- ----------------------------
DROP VIEW IF EXISTS `s_risk_danger_day`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `s_risk_danger_day` AS select ifnull(sum((case when (`p_latent_danger`.`danger_level` = '1') then 1 else 0 end)),0) AS `general`,ifnull(sum((case when (`p_latent_danger`.`danger_level` = '2') then 1 else 0 end)),0) AS `major`,ifnull(sum((case when (`p_latent_danger`.`danger_level` = '0') then 1 else 0 end)),0) AS `safety_problem`,cast(now() as date) AS `vest_date`,`p_latent_danger`.`org_code` AS `org_code`,now() AS `update_date` from `p_latent_danger` where (cast(`p_latent_danger`.`create_date` as date) = cast(now() as date)) ;

-- ----------------------------
-- View structure for s_risk_danger_month
-- ----------------------------
DROP VIEW IF EXISTS `s_risk_danger_month`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `s_risk_danger_month` AS select ifnull(sum((case when (`p_latent_danger`.`danger_level` = '1') then 1 else 0 end)),0) AS `general`,ifnull(sum((case when (`p_latent_danger`.`danger_level` = '2') then 1 else 0 end)),0) AS `major`,ifnull(sum((case when (`p_latent_danger`.`danger_level` = '0') then 1 else 0 end)),0) AS `safety_problem`,year(now()) AS `year`,month(now()) AS `month`,`p_latent_danger`.`org_code` AS `org_code`,now() AS `update_date` from `p_latent_danger` where ((month(`p_latent_danger`.`create_date`) = month(now())) and (year(`p_latent_danger`.`create_date`) = year(now()))) ;

-- ----------------------------
-- View structure for s_risk_danger_week
-- ----------------------------
DROP VIEW IF EXISTS `s_risk_danger_week`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `s_risk_danger_week` AS select ifnull(sum((case when (`p_latent_danger`.`danger_level` = '1') then 1 else 0 end)),0) AS `general`,ifnull(sum((case when (`p_latent_danger`.`danger_level` = '2') then 1 else 0 end)),0) AS `major`,ifnull(sum((case when (`p_latent_danger`.`danger_level` = '0') then 1 else 0 end)),0) AS `safety_problem`,year(now()) AS `year`,week(now(),0) AS `week`,`p_latent_danger`.`org_code` AS `org_code`,now() AS `update_date` from `p_latent_danger` where ((week(`p_latent_danger`.`create_date`,0) = week(now(),0)) and (year(`p_latent_danger`.`create_date`) = year(now()))) ;

-- ----------------------------
-- View structure for vcheck
-- ----------------------------
DROP VIEW IF EXISTS `vcheck`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `vcheck` AS select `a`.`id` AS `id`,`a`.`org_code` AS `org_code`,`a`.`point_id` AS `point_id`,`b`.`name` AS `point_name`,`b`.`is_fixed` AS `is_fixed`,`b`.`point_no` AS `point_no`,`a`.`user_id` AS `user_id`,date_format(`a`.`check_time`,'%Y-%m-%d %H:%i:%s') AS `check_time`,date_format(`a`.`upload_time`,'%Y-%m-%d %H:%i:%s') AS `upload_time`,(case when ((`a`.`plan_task_detail_id` = 0) or isnull(`a`.`plan_task_detail_id`)) then '0' when ((`a`.`plan_task_detail_id` <> 0) and (`a`.`is_ok` <> 3)) then '1' when (`a`.`is_ok` = 3) then '2' end) AS `Finish_Status`,`a`.`is_ok` AS `is_ok`,`a`.`score` AS `score`,`a`.`route_id` AS `route_id`,`d`.`name` AS `route_name`,`a`.`check_mode` AS `check_mode`,`a`.`plan_id` AS `plan_id`,`e`.`name` AS `plan_name`,`b`.`catalog_id` AS `catalog_id`,`a`.`plan_task_id` AS `plan_task_id`,`a`.`error` AS `error`,`a`.`remark` AS `remark`,`e`.`dept_id` AS `department_id` from ((((`p_check` `a` left join `p_point` `b` on((`a`.`point_id` = `b`.`id`))) left join `p_route` `d` on((`a`.`route_id` = `d`.`id`))) left join `p_plan` `e` on((`a`.`plan_id` = `e`.`id`))) left join `p_catalog_tree` `f` on((`b`.`catalog_id` = `f`.`id`))) ;

-- ----------------------------
-- View structure for v_check_info
-- ----------------------------
DROP VIEW IF EXISTS `v_check_info`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_check_info` AS select `sss`.`CheckTime` AS `CheckTime`,`sss`.`UserID` AS `UserID`,`sss`.`PointID` AS `PointID`,`sss`.`CheckID` AS `CheckID`,`sss`.`STATUS` AS `STATUS`,`sss`.`orgCode` AS `orgCode`,`sss`.`TaskID` AS `TaskID`,(case `sss`.`STATUS` when '2' then (select group_concat(`ii`.`name` separator ';') from (`p_check_input` `ci` join `p_input_item` `ii`) where ((`ci`.`check_id` = `sss`.`CheckID`) and (`ci`.`is_ok` = '2') and (`ci`.`input_id` = `ii`.`id`))) end) AS `ErrorMsg` from (select `ss`.`CheckTime` AS `CheckTime`,`ss`.`UserID` AS `UserID`,`ss`.`PointID` AS `PointID`,`ss`.`CheckID` AS `CheckID`,`ss`.`STATUS` AS `STATUS`,`ss`.`orgCode` AS `orgCode`,`ttemp`.`TaskID` AS `TaskID` from (((select `a`.`check_time` AS `CheckTime`,`a`.`user_id` AS `UserID`,`a`.`point_id` AS `PointID`,`a`.`id` AS `CheckID`,`a`.`is_ok` AS `STATUS`,`a`.`org_code` AS `orgCode` from (`p_check` `a` join `p_point` `p`) where (`p`.`id` = `a`.`point_id`))) `ss` left join (select `td`.`check_id` AS `check_id`,group_concat(`td`.`task_id` separator ',') AS `TaskID` from (`p_task_detail` `td` join (select `a`.`check_time` AS `CheckTime`,`a`.`user_id` AS `UserID`,`a`.`point_id` AS `PointID`,`a`.`id` AS `CheckID`,`a`.`is_ok` AS `STATUS`,`p`.`name` AS `pointName`,`a`.`org_code` AS `orgCode` from (`p_check` `a` join `p_point` `p`) where (`p`.`id` = `a`.`point_id`)) `ss_`) where (`td`.`check_id` = `ss_`.`CheckID`) group by `td`.`check_id`) `ttemp` on((`ttemp`.`check_id` = `ss`.`CheckID`)))) `sss` ;

-- ----------------------------
-- View structure for v_msg_subscribe_check
-- ----------------------------
DROP VIEW IF EXISTS `v_msg_subscribe_check`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_msg_subscribe_check` AS select `p_msg_subscribe`.`user_id` AS `user_id`,max((case when (`p_msg_subscribe`.`msg_type` = 'checkEmail') then `p_msg_subscribe`.`attribute1` end)) AS `check_email`,max((case when (`p_msg_subscribe`.`msg_type` = 'checkType') then `p_msg_subscribe`.`attribute1` end)) AS `check_type`,max((case when (`p_msg_subscribe`.`msg_type` = 'route') then `p_msg_subscribe`.`attribute1` end)) AS `route` from `p_msg_subscribe` group by `p_msg_subscribe`.`user_id` ;

-- ----------------------------
-- View structure for v_person_plan_task
-- ----------------------------
DROP VIEW IF EXISTS `v_person_plan_task`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_person_plan_task` AS select `pt`.`id` AS `taskId`,substring_index(substring_index(`pt`.`user_id`,',',(`pt2`.`help_topic_id` + 1)),',',-(1)) AS `user_id`,`pt`.`check_date` AS `check_date` from (`p_plan_task` `pt` join `mysql`.`help_topic` `pt2` on((`pt2`.`help_topic_id` < ((length(`pt`.`user_id`) - length(replace(`pt`.`user_id`,',',''))) + 1)))) ;

-- ----------------------------
-- View structure for v_point_last_check
-- ----------------------------
DROP VIEW IF EXISTS `v_point_last_check`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_point_last_check` AS select `a`.`point_id` AS `point_id`,`a`.`check_time` AS `check_time`,(case `a`.`is_ok` when '2' then (select group_concat(`c`.`name` separator ';') from (`p_check_input` `b` join `p_input_item` `c`) where ((`b`.`check_id` = `a`.`id`) and (`b`.`input_id` = `c`.`id`) and (`b`.`is_ok` = '2'))) when '3' then '漏检' end) AS `errorMsg` from `p_check` `a` where (`a`.`id` = (select max(`pc`.`id`) from `p_check` `pc` where (`a`.`point_id` = `pc`.`point_id`))) ;

-- ----------------------------
-- Procedure structure for everyDayInitPlanTaskStatistics
-- ----------------------------
DROP PROCEDURE IF EXISTS `everyDayInitPlanTaskStatistics`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` PROCEDURE `everyDayInitPlanTaskStatistics`()
BEGIN
    declare userId bigint ;
    declare orgCode VARCHAR(50) ;
    declare currentDate VARCHAR(40) ;
    declare planTaskNum BIGINT ;
    declare planTaskFinishNum BIGINT ;
    declare personNum BIGINT ;
    DECLARE done BOOLEAN DEFAULT 0;
    DECLARE p_p_conf CURSOR FOR select id from s_user u where u.enabled = 1 AND u.is_delete = 0;
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET done=1;
    set currentDate = SYSDATE();
    open p_p_conf;
    REPEAT
        FETCH p_p_conf INTO userId;
        if done != 1 THEN
            BEGIN
                DECLARE orgDone BOOLEAN DEFAULT 0;
                DECLARE org_plan_task CURSOR FOR SELECT sum(finish_num), sum(point_num),org_code FROM p_plan_task WHERE  find_in_set(userId,user_id)>0 AND end_time >= STR_TO_DATE(SYSDATE(),'%Y-%m-%d') GROUP BY org_code;
                DECLARE CONTINUE HANDLER FOR NOT FOUND SET orgDone=1;

                open org_plan_task;
                REPEAT
                    FETCH org_plan_task INTO planTaskFinishNum, planTaskNum, orgCode;
                    if done != 1 THEN
                        if planTaskNum is null then
                            set planTaskNum = 0;
                        end if;
                        if planTaskFinishNum is null then
                            set planTaskFinishNum = 0;
                        end if;
                        SELECT count(1) into personNum FROM p_plan_exec_statistics where check_time = DATE_FORMAT(currentDate, '%Y-%m-%d') AND user_id = userId AND org_code = orgCode;
                        if orgCode is not null then
                            if personNum > 0 THEN
                                update p_plan_exec_statistics SET plan_task_num = planTaskNum, exec_plan_task_num = planTaskFinishNum, missed_check_num=0, outside_plan_num=0  where check_time = DATE_FORMAT(currentDate, '%Y-%m-%d') AND user_id = userId AND org_code = orgCode;
                            ELSE
                                INSERT INTO p_plan_exec_statistics(check_time,org_code,user_id,plan_task_num,exec_plan_task_num,missed_check_num,outside_plan_num)
                                VALUES(DATE_FORMAT(currentDate, '%Y-%m-%d'), orgCode, userId, planTaskNum, planTaskFinishNum, 0, 0);
                            end if;
                        end if;
                    end if;
                UNTIL orgDone END REPEAT;
                CLOSE org_plan_task;
            END;
        end if;

    UNTIL done END REPEAT;
    CLOSE p_p_conf;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for planTaskStatistics
-- ----------------------------
DROP PROCEDURE IF EXISTS `planTaskStatistics`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` PROCEDURE `planTaskStatistics`(IN `userId` VARCHAR(50) ,IN `currentDate` VARCHAR(40),IN `orgCode` VARCHAR(50))
BEGIN
    declare planTaskNum BIGINT ;
    declare planTaskFinishNum BIGINT ;
    declare missedNum BIGINT ;
    declare personNum BIGINT ;
    declare outsideNum BIGINT ;
    if currentDate is null THEN
        set currentDate = DATE_FORMAT(SYSDATE(), '%Y-%m-%d');
    end if;
    if  userId !='' then
        SELECT sum(a.finish_num), sum(a.point_num), sum(a.miss),org_code FROM (
                                                                                  SELECT finish_num, point_num, org_code, CASE finish_status WHEN 3 THEN (point_num - finish_num) ELSE 0 END miss
                                                                                  FROM p_plan_task WHERE find_in_set(userId,user_id)>0 AND DATE_FORMAT(end_time, '%Y-%m-%d') >=currentDate AND DATE_FORMAT(begin_time, '%Y-%m-%d')<=  currentDate AND LOCATE(orgCode, org_code)> 0  ) a INTO planTaskFinishNum, planTaskNum, missedNum, orgCode;
        if planTaskNum is null then
            set planTaskNum = 0;
        end if;
        if planTaskFinishNum is null then
            set planTaskFinishNum = 0;
        end if;
        if outsideNum is null then
            set outsideNum = 0;
        end if;
        if planTaskNum > 0 then

            SELECT count(1) into personNum FROM p_plan_exec_statistics where check_time = currentDate AND user_id = userId AND org_code = orgCode;

            if personNum > 0 then
                SELECT count(1) into outsideNum FROM p_check where DATE_FORMAT(check_time, '%Y-%m-%d') = currentDate AND find_in_set(userId,user_id)>0 and org_code = (select substring(orgCode,1,(SELECT INSTR(orgCode,'-')-1))) and plan_task_id = 0;
                update p_plan_exec_statistics SET plan_task_num = planTaskNum, exec_plan_task_num = planTaskFinishNum, missed_check_num=missedNum, outside_plan_num=outsideNum  where check_time = currentDate AND user_id = userId AND org_code = orgCode;
            ELSE
                SELECT count(1) into outsideNum FROM p_check where DATE_FORMAT(check_time, '%Y-%m-%d') = currentDate AND find_in_set(userId,user_id)>0 and org_code = (select substring(orgCode,1,(SELECT INSTR(orgCode,'-')-1))) and (plan_task_id = 0 or plan_task_id = null);
                INSERT INTO p_plan_exec_statistics(check_time,org_code,user_id,plan_task_num,exec_plan_task_num,missed_check_num,outside_plan_num)
                VALUES(currentDate, orgCode, userId, planTaskNum, planTaskFinishNum, missedNum, outsideNum);
            end if;
        end if;
    end if;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for updatePlanTask
-- ----------------------------
DROP PROCEDURE IF EXISTS `updatePlanTask`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` PROCEDURE `updatePlanTask`(IN `planTaskId` int,IN `pointId` int,IN `planTaskDetailId` int,IN `executorId` int)
BEGIN
    declare num int ;
    declare orgCode VARCHAR(50) ;
    declare currentTaskNum int ;
    update p_plan_task_detail set is_finish = 1 where id=planTaskDetailId;
    select finish_num, org_code from p_plan_task where id = planTaskId into num, orgCode;
    select count(1) into currentTaskNum from p_plan_task_detail where task_no = planTaskId and is_finish in(0,2);
    UPDATE p_plan_task_detail SET executor_id = executorId,executor_date = current_timestamp where id = planTaskDetailId;
    if currentTaskNum > 0 THEN
        update p_plan_task set finish_num = (num + 1) where id = planTaskId;
    ELSE
        update p_plan_task set finish_num = (num + 1), finish_status = 2 where id = planTaskId;
    end if;
    if executorId > 0 then
        call planTaskStatistics(executorId, null, orgCode);
    end if;
END
;;
DELIMITER ;

-- ----------------------------
-- Event structure for planTaskStatisticsaEvent
-- ----------------------------
DROP EVENT IF EXISTS `planTaskStatisticsaEvent`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` EVENT `planTaskStatisticsaEvent` ON SCHEDULE EVERY 1 DAY STARTS '2021-04-14 00:00:00' ON COMPLETION PRESERVE ENABLE DO CALL everyDayInitPlanTaskStatistics()
;;
DELIMITER ;
DROP TRIGGER IF EXISTS `trigger_check_insert`;
DELIMITER ;;
CREATE TRIGGER `trigger_check_insert` AFTER INSERT ON `p_check` FOR EACH ROW BEGIN
    UPDATE p_plan_task_detail SET status =  NEW.is_ok WHERE id = NEW.plan_task_detail_id;
    UPDATE p_point SET `status` = NEW.is_ok,error = NEW.error,check_time = NEW.check_time WHERE id = NEW.point_id;
END
;;
DELIMITER ;
DROP TRIGGER IF EXISTS `trigger_check_update`;
DELIMITER ;;
CREATE TRIGGER `trigger_check_update` AFTER UPDATE ON `p_check` FOR EACH ROW BEGIN
    UPDATE p_plan_task_detail SET status =  NEW.is_ok WHERE id = NEW.plan_task_detail_id;
    UPDATE p_point SET `status` = NEW.is_ok,error = NEW.error,check_time = NEW.check_time WHERE id = NEW.point_id;
END
;;
DELIMITER ;
DROP TRIGGER IF EXISTS `trigger_plan_task_detail_insert`;
DELIMITER ;;
CREATE TRIGGER `trigger_plan_task_detail_insert` AFTER INSERT ON `p_plan_task_detail` FOR EACH ROW BEGIN
    DECLARE pointId bigint(20);
    DECLARE pointStatus varchar (50);
    SET  pointId = NEW.point_id;
    SELECT status into pointStatus FROM p_point WHERE id = pointId;
    IF pointStatus = '0' THEN
        UPDATE p_point SET status = '1' WHERE id = pointId;
    END IF;
END
;;
DELIMITER ;
DROP TRIGGER IF EXISTS `addPointConfig`;
DELIMITER ;;
CREATE TRIGGER `addPointConfig` AFTER INSERT ON `p_point` FOR EACH ROW BEGIN
    INSERT INTO p_point_config(`name`, point_id, point_code, infomation_address, `status`, update_date)
    VALUES(CONCAT(new.name,'漏检'), new.id, CONCAT('N',LPAD(new.id, 10, 0)), 0, 0, SYSDATE());
    INSERT INTO p_point_config(`name`, point_id, point_code, infomation_address, `status`, update_date)
    VALUES(CONCAT(new.name,'合格'), new.id, CONCAT('S',LPAD(new.id, 10, 0)) ,0, 0, SYSDATE());
END
;;
DELIMITER ;
DROP TRIGGER IF EXISTS `updatePointConfig`;
DELIMITER ;;
CREATE TRIGGER `updatePointConfig` AFTER UPDATE ON `p_point` FOR EACH ROW BEGIN
    IF (new.name != old.name)
    THEN
        UPDATE p_point_config pc SET pc.`name` = CONCAT(new.name,'合格') WHERE pc.name LIKE '%合格' AND pc.point_id = new.id;
        UPDATE p_point_config pc SET pc.`name` = CONCAT(new.name,'漏检')  WHERE pc.name LIKE '%漏检' AND pc.point_id = new.id;
    END IF;
END
;;
DELIMITER ;
DROP TRIGGER IF EXISTS `deletePointConfig`;
DELIMITER ;;
CREATE TRIGGER `deletePointConfig` AFTER DELETE ON `p_point` FOR EACH ROW BEGIN
    update p_point_config set is_delete = 1 where point_id = old.id;
END
;;
DELIMITER ;
DROP TRIGGER IF EXISTS `trigger_p_point_classify_delete`;
DELIMITER ;;
CREATE TRIGGER `trigger_p_point_classify_delete` AFTER DELETE ON `p_point_classify` FOR EACH ROW BEGIN
    update p_route_point_item rpi set rpi.point_classify_id = null where rpi.point_classify_id = old.id;
    update p_point_inputitem pi set pi.classify_ids = substring(replace(concat(',',pi.classify_ids,','),concat(',',old.id,','),','),2,LENGTH(replace(concat(',',pi.classify_ids,','),concat(',',old.id,','),''))-1)  where FIND_IN_SET(old.id, pi.classify_ids);
END
;;
DELIMITER ;
DROP TRIGGER IF EXISTS `trigger_route_point_insert_update_point_route_info`;
DELIMITER ;;
CREATE TRIGGER `trigger_route_point_insert_update_point_route_info` AFTER INSERT ON `p_route_point` FOR EACH ROW BEGIN

    DECLARE pointId BIGINT (20);


    DECLARE routeId VARCHAR (1000);


    DECLARE routeName VARCHAR (1000);


    SET pointId = NEW.point_id;

    SELECT
        GROUP_CONCAT(id),
        GROUP_CONCAT(NAME) INTO routeId,
        routeName
    FROM
        (
            SELECT
                pr.id,
                pr. NAME
            FROM
                p_route_point prp
                    LEFT JOIN p_route pr ON pr.id = prp.route_id
            WHERE
                    prp.point_id = pointId
            GROUP BY
                pr.id
        ) t;

    UPDATE p_point
    SET route_id = routeId,
        route_name = routeName
    WHERE
            id = pointId;


END
;;
DELIMITER ;
DROP TRIGGER IF EXISTS `trigger_route_point_update_update_point_route_info`;
DELIMITER ;;
CREATE TRIGGER `trigger_route_point_update_update_point_route_info` AFTER UPDATE ON `p_route_point` FOR EACH ROW BEGIN

    DECLARE pointId BIGINT (20);


    DECLARE routeId VARCHAR (1000);


    DECLARE routeName VARCHAR (1000);


    SET pointId = OLD.point_id;

    SELECT
        GROUP_CONCAT(id),
        GROUP_CONCAT(NAME) INTO routeId,
        routeName
    FROM
        (
            SELECT
                pr.id,
                pr. NAME
            FROM
                p_route_point prp
                    LEFT JOIN p_route pr ON pr.id = prp.route_id
            WHERE
                    prp.point_id = pointId
            GROUP BY
                pr.id
        ) t;

    UPDATE p_point
    SET route_id = routeId,
        route_name = routeName
    WHERE
            id = pointId;


END
;;
DELIMITER ;
DROP TRIGGER IF EXISTS `trigger_route_point_delete_update_point_route_info`;
DELIMITER ;;
CREATE TRIGGER `trigger_route_point_delete_update_point_route_info` AFTER DELETE ON `p_route_point` FOR EACH ROW BEGIN

    DECLARE pointId BIGINT (20);


    DECLARE routeId VARCHAR (1000);


    DECLARE routeName VARCHAR (1000);


    SET pointId = OLD.point_id;

    SELECT
        GROUP_CONCAT(id),
        GROUP_CONCAT(NAME) INTO routeId,
        routeName
    FROM
        (
            SELECT
                pr.id,
                pr. NAME
            FROM
                p_route_point prp
                    LEFT JOIN p_route pr ON pr.id = prp.route_id
            WHERE
                    prp.point_id = pointId
            GROUP BY
                pr.id
        ) t;

    UPDATE p_point
    SET route_id = routeId,
        route_name = routeName
    WHERE
            id = pointId;


END
;;
DELIMITER ;
SET FOREIGN_KEY_CHECKS=1;
