package com.yeejoin.amos.boot.module.tzs.flc.api.feign;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

@FeignClient(value = "AMOS-IDX", path = "idx")
public interface IdxFeignService {

    @RequestMapping("/dimensionTable/getTreeChildIds")
    ResponseModel<List<String>> getTreeChildIds(@RequestParam String dimensionTableId, @RequestParam String selectValue);

    /**
     * 查询表详情和表字段
     *
     * @param tableId
     * @return
     */
    @RequestMapping(value = "/table/{tableId}", method = RequestMethod.GET)
    ResponseModel<JSONObject> queryByTableId(@PathVariable String tableId);

}
