package com.yeejoin.amos.boot.module.jg.api.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.mapper.CustomBaseMapper;
import com.yeejoin.amos.boot.module.jg.api.dto.CompanyEquipCountDto;
import com.yeejoin.amos.boot.module.jg.api.dto.JgMaintainNoticeDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgMaintainNotice;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import com.yeejoin.amos.boot.module.jg.api.vo.tableDataExportVo.MaintainVo;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * Mapper 接口
 *
 * @author system_generator
 * @date 2023-12-12
 */
public interface JgMaintainNoticeMapper extends CustomBaseMapper<JgMaintainNotice> {
    /**
     * 分页查询
     *
     * @param page  分页对象
     * @param model 查询参数
     * @param type  类型：enterprise-企业端、supervision-监管端
     * @return 维修告知列表
     */
    Page<Map<String,Object>> queryForPage(Page<JgMaintainNotice> page,
                                          @Param("sort") SortVo sortMap,
                                          @Param("param") JgMaintainNoticeDto model,
                                          @Param("type") String type,
                                          @Param("companyCode") String companyCode,
                                          @Param("userId") String userId,
                                          @Param("orgCode") String orgCode);

    /**
     * 根据维修告知编号查询设备、设计、制造等信息
     *
     * @param sequenceNbr 维修告知编号
     */
    @MapKey("sequenceNbr")
    List<Map<String, Object>> queryEquipInformation(@Param("sequenceNbr") long sequenceNbr);

    void updatePromoter(@Param("id")Long id);

    List<CompanyEquipCountDto> queryForFlowingEquipList();

    List<MaintainVo> queryMaintainInIds(@Param("ids") List<String> ids);

    IPage<Map<String, Object>> selectPipeLinePage(@Param("page") Page<Map<String, Object>> page, @Param("projectContraptionId") String projectContraptionId, @Param("filters") Map<String, Object> filters);

    List<Map<String, Object>> selectPipeLineByRecords(@Param("records") List<String> records);

}
