package com.yeejoin.amos.boot.module.jg.biz.edit.typeHandler;

import com.yeejoin.amos.boot.biz.common.typeHandler.TypeHandler;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * 资料是否齐全处理器
 */
@Component("isCompleteTypeHandler")
public class IsCompleteTypeHandler implements TypeHandler<String> {

    private static final Map<String, String> IS_COMPLETE_MAP = new HashMap<>();

    static {
        IS_COMPLETE_MAP.put("1", "齐全");
        IS_COMPLETE_MAP.put("2", "不齐全");
    }

    @Override
    public String handle(String value) {
        return IS_COMPLETE_MAP.get(value);
    }
}
