package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.DPSubServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;


/**
 * 大屏统计controller
 *
 * @author Administrator
 */
@RestController
@Api(tags = "大屏二级弹窗")
@RequestMapping("/dp/sub")
public class DPSubController {


    private DPSubServiceImpl subService;

    public DPSubController(DPSubServiceImpl subService) {
        this.subService = subService;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "动态详情页", notes = "动态详情页")
    @PostMapping(value = "/{template}")
    public ResponseModel<JSONObject> commonQuery(@PathVariable String template, @RequestBody Map<String, Object> param) {
        if (template.equals("company")) { // 企业
            Assert.notNull(param.get("useUnitCode"), "企业统一信用代码不能为空");
            if (ValidationUtil.isEmpty(param.get("useUnit"))){
                param.put("useUnit", param.get("unitName"));
            }
        } else if (template.equals("reportEqu")) { // 监督检验
            Assert.notNull(param.get("sequenceNbr"), "sequenceNbr不能为空");
        } else if (template.equals("equip")) { //设备
            if (ValidationUtil.isEmpty(param.get("record"))){
                param.put("record", param.get("SEQUENCE_NBR"));
            }
            if (ValidationUtil.isEmpty(param.get("equList"))){
                param.put("equList", param.get("EQU_LIST_CODE"));
            }
//            if (ValidationUtil.isEmpty(param.get("PRODUCT_NAME"))){
//                param.put("PRODUCT_NAME", param.get("EQU_LIST"));
//            }
            if (!ValidationUtil.isEmpty(param.get("equListCode"))){ // 问题列表关联设备
                param.put("equList", param.get("equListCode"));
                param.put("EQU_LIST_CODE", param.get("equListCode"));
                param.put("SEQUENCE_NBR", param.get("record"));
            }
            Assert.notNull(param.get("record"), "设备ID不能为空");
            Assert.notNull(param.get("equList"), "设备种类不能为空");
            template = template + "_" + param.get("equList");
        } else if (template.equals("emergency")) { // 应急
            if (!ValidationUtil.isEmpty(param.get("alertId"))){
                param.put("sequenceNbr", param.get("alertId"));
            }
            Assert.notNull(param.get("sequenceNbr"), "sequenceNbr不能为空");
        } else if(template.equals("problem")) { // 隐患
            if (ValidationUtil.isEmpty(param.get("sequenceNbr"))){
                param.put("sequenceNbr", param.get("alertId"));
            }
            Assert.notNull(param.get("sequenceNbr"), "sequenceNbr不能为空");
            template = subService.getOverrideTemplateName(template, (String) param.get("problemTypeCode"));
        } else if(template.equals("registration")) { // 登记证
            Assert.notNull(param.get("sequenceNbr"), "sequenceNbr不能为空");
        } else if(template.equals("inspection")) { // 报检
            template = template + "_" + param.get("equListCode");
            Assert.notNull(param.get("sequenceNbr"), "sequenceNbr不能为空");
        } else if(template.equals("sydj")){
            Assert.notNull(param.get("sequenceNbr"), "sequenceNbr不能为空");
            if("vehicle".equals(param.get("bType"))){
                template = template + "_" + param.get("bType");
            }
        } else if(template.equals("azgz")){
            Assert.notNull(param.get("sequenceNbr"), "sequenceNbr不能为空");
        } else if(template.equals("jdjy")){
            Assert.notNull(param.get("sequenceNbr"), "sequenceNbr不能为空");
        } else if(template.equals("dqjy")){
            Assert.notNull(param.get("sequenceNbr"), "sequenceNbr不能为空");
        } else if(template.equals("bgdj")){
            Assert.notNull(param.get("sequenceNbr"), "sequenceNbr不能为空");
            template = template + "_" + param.get("bType");
        } else if(template.equals("zxbf")){
            Assert.notNull(param.get("sequenceNbr"), "sequenceNbr不能为空");
        } else {
            throw new RuntimeException("暂无模板");
        }
        return ResponseHelper.buildResponse(subService.commonQuery(template, param));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "tab返回单个详情数据", notes = "tab返回单个详情数据")
    @PostMapping(value = "/tab/aloneApi")
    public ResponseModel<Object> aloneApi(@RequestBody Map map) {
        return ResponseHelper.buildResponse(subService.aloneApi(JSONObject.parseObject(JSON.toJSONString(map))));
    }
}


