package com.yeejoin.amos.boot.module.ugp.api.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.InstallNoticeDto;
import com.yeejoin.amos.boot.module.ugp.api.dto.InstallNoticePageDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.InstallNotice;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * 安装告知表 Mapper 接口
 *
 * @author system_generator
 * @date 2022-09-22
 */
public interface InstallNoticeMapper extends BaseMapper<InstallNotice> {
    //安装告知申请页面列表
    List<InstallNoticePageDto> installNoticeList();
    //筛选sequenceNbr查询安装告知申请页面数据
    List<InstallNoticePageDto> selectByName(@Param("name") String name , @Param("unit") String unit);
    //根据
    InstallNoticePageDto selectById(@Param("sequenceNbr")Long sequenceNbr);

    //安装告知申请页面分页列表
    Page<InstallNoticePageDto> installNoticePage(IPage<InstallNoticePageDto> page,@RequestParam String name,@RequestParam String constructionUnit);

    //根据project_id提交改变申请状态
    void submit (Long sequenceNbr);

    //根据project_id查询一条数据
    InstallNoticeDto selectOneByPid(Long sequenceNbr );

    //根据sequenceNbr查询告知申请详情
    InstallNoticeDto selectoneById(@RequestParam("sequenceNbr")Long sequenceNbr );



}
