package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.BeforeDto;
import com.yeejoin.amos.boot.module.ugp.api.dto.IntelligentInspectionDto;
import com.yeejoin.amos.boot.module.ugp.api.dto.PercentOfPassDto;
import com.yeejoin.amos.boot.module.ugp.api.service.IIntelligentInspectionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

/**
 * @Author cpp
 * @Description 【智能监检与评价管理】【焊前准备校验】管材质量校验
 * @Date 2022/10/13
 */@RestController
@Api(tags = "焊接管材检验信息列表Api")
@RequestMapping(value = "/intelligent-inspection")
public class IntelligentInspectionController {

   @Autowired
    IIntelligentInspectionService services;


  @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/selectInspection")
    @ApiOperation(httpMethod = "GET", value = "焊接管材检验信息列表", notes = "焊接管材检验信息列表")
    public ResponseModel<Page<BeforeDto>> selectInspection(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size, BeforeDto dto) {
        Page<BeforeDto> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(services.selectInspection(page,dto));
    }


}
