package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.ugp.api.dto.MaterialDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.Project;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.OrgServiceImpl;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.ProjectInitiationServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.ProjectServiceImpl;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.ProjectDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 项目信息表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@RestController
@Api(tags = "项目信息表Api")
@RequestMapping(value = "/project")
public class ProjectController extends BaseController {

	@Autowired
	ProjectServiceImpl projectServiceImpl;
	@Autowired
	ProjectInitiationServiceImpl projectInitiationService;
	@Autowired
	OrgServiceImpl orgServiceImpl;

	/**
	 * 新增项目信息表
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增项目信息表", notes = "新增项目信息表")
	public ResponseModel<ProjectDto> save(@RequestBody ProjectDto model) {
		model.setStartDate(new Date());
		model.setSubmitDate(new Date());
		model = projectServiceImpl.createWithModel(model);
		Project project = new Project();
		BeanUtils.copyProperties(model, project);
		projectInitiationService.start(project);
		return ResponseHelper.buildResponse(model);
	}

	/**
	 * 根据sequenceNbr更新
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新项目信息表", notes = "根据sequenceNbr更新项目信息表")
	public ResponseModel<ProjectDto> updateBySequenceNbrProject(@RequestBody ProjectDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		model.setRecDate(new Date());
		model.setSequenceNbr(sequenceNbr);
		return ResponseHelper.buildResponse(projectServiceImpl.updateWithModel(model));
	}

	/**
	 * 根据sequenceNbr删除
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@DeleteMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除项目信息表", notes = "根据sequenceNbr删除项目信息表")
	public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		return ResponseHelper.buildResponse(projectServiceImpl.removeById(sequenceNbr));
	}

	/**
	 * 根据sequenceNbr查询
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个项目信息表", notes = "根据sequenceNbr查询单个项目信息表")
	public ResponseModel<ProjectDto> selectOne(@PathVariable Long sequenceNbr) {
		return ResponseHelper.buildResponse(projectServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
	 * 列表分页查询
	 *
	 * @param current 当前页
	 * @param current 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "项目信息表分页查询",  notes = "项目信息表分页查询")
	public ResponseModel<Page<ProjectDto>> queryForPage(
			@RequestParam(value = "current") int current,
			@RequestParam(value = "size") int size,
			@RequestParam(value = "name",required = false) String name,
			@RequestParam(value = "constructionUnit",required = false) String constructionUnit
	) {
		Page<ProjectDto> page = new Page<ProjectDto>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(projectServiceImpl.queryForProjectPage(page, name, constructionUnit));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "项目信息表列表全部数据查询",   notes = "项目信息表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<ProjectDto>> selectForList() {
	    return ResponseHelper.buildResponse(projectServiceImpl.queryForProjectList());
	}
	/**
	 * 查询项目名称
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "查询项目名称", notes = "查询项目名称")
	@GetMapping(value = "/selectName")
	public ResponseModel<List<JSONObject>> selectName() {
		return ResponseHelper.buildResponse(projectServiceImpl.selectName());
	}

	/**
	 * 获取下拉选择值
	 * @param type INSTALL("安装单位")、DESIGN("设计单位")、SUPERVISION（”监察单位“）、MONITORING（”监检机构“）
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "查询下拉选择框的值", notes = "查询下拉选择框的值")
	@GetMapping(value = "/getSelectInfo")
	public ResponseModel<List<OrgUsr>> getSelectInfo(String type){
		return ResponseHelper.buildResponse(orgServiceImpl.getSelectInfo(type));
	}

	/**
	 * 查询当前登录单位下的人员列表
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "查询下拉选择框的值", notes = "查询下拉选择框的值")
	@GetMapping(value = "/getCharge")
	public ResponseModel<List<OrgUsr>> getCharge(){
		return ResponseHelper.buildResponse(orgServiceImpl.getCharge());
	}

	/**
	 * 查询当前登陆人所在单位下的所以项目列表
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "查询当前登陆人所在单位下的所以项目列表", notes = "查询当前登陆人所在单位下的所以项目列表")
	@GetMapping(value = "/getCompanyProjects")
	public ResponseModel<List<Project>> getCompanyProjects(){
		Long companyId = null;
		//获取当前登陆人所在单位id
//		companyId = orgServiceImpl.getCompanyId();
//		if(ValidationUtil.isEmpty(companyId)){
//			return ResponseHelper.buildResponse(new ArrayList<>());
//		}
		LambdaQueryWrapper<Project> wrapper = new LambdaQueryWrapper<>();
		if (!ValidationUtil.isEmpty(companyId)) {
			wrapper.eq(Project::getConstructionUnitId,companyId);
		}

		return ResponseHelper.buildResponse(projectServiceImpl.list(wrapper));
	}
}
