package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.ugp.api.entity.TzUgpTask;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.TzUgpTaskServiceImpl;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;


/**
 * 监检任务表
 *
 * @author duanwei
 * @date 2022-10-19
 */
@RestController
@Api(tags = "监检任务表Api")
@RequestMapping(value = "/tz-ugp-task", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class TzUgpTaskController {

  @Autowired
  TzUgpTaskServiceImpl iTzUgpTaskService;


    /**
    * 新增监检任务表
    * @return
    */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增监检任务表", notes = "新增监检任务表")
    public boolean saveTzUgpTask(HttpServletRequest request, @RequestBody TzUgpTask tzUgpTask){
    return iTzUgpTaskService.save(tzUgpTask);
    }

    /**
    * 根据id删除
    * @param id
    * @return
    */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id){
    return iTzUgpTaskService.removeById(id);
    }




    /**
    * 修改监检任务表
    * @return
    */
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改监检任务表", notes = "修改监检任务表")
    public boolean updateByIdTzUgpTask(HttpServletRequest request, @RequestBody TzUgpTask tzUgpTask){
    return iTzUgpTaskService.updateById(tzUgpTask);
    }



    /**
   * 根据id查询
   * @param id
   * @return
   */
   @RequestMapping(value = "/{id}", method = RequestMethod.GET)
   @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
   public TzUgpTask selectById(HttpServletRequest request, @PathVariable Long id){
      return iTzUgpTaskService.getById(id);
   }



  /**
  * 列表分页查询
  * @return
  */
  @RequestMapping(value = "/list", method = RequestMethod.GET)
  @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
  public IPage<TzUgpTask> listPage(String pageNum,String pageSize,
    TzUgpTask tzUgpTask){

    Page<TzUgpTask> pageBean;
    QueryWrapper<TzUgpTask> tzUgpTaskQueryWrapper = new QueryWrapper<>();
    Class<? extends TzUgpTask> aClass = tzUgpTask.getClass();
    Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
        try {
            field.setAccessible(true);
            Object o = field.get(tzUgpTask);
            if (o != null) {
                Class<?> type = field.getType();
                String name = NameUtils.camel2Underline(field.getName());
                if (type.equals(Integer.class)) {
                Integer fileValue = (Integer) field.get(tzUgpTask);
                tzUgpTaskQueryWrapper.eq(name, fileValue);
                } else if (type.equals(Long.class)) {
                Long fileValue = (Long) field.get(tzUgpTask);
                tzUgpTaskQueryWrapper.eq(name, fileValue);
                } else if (type.equals(String.class)) {
                String fileValue = (String) field.get(tzUgpTask);
                tzUgpTaskQueryWrapper.eq(name, fileValue);
                } else {
                String fileValue = (String) field.get(tzUgpTask);
                tzUgpTaskQueryWrapper.eq(name, fileValue);
            }
          }
        }catch (Exception e) {
        }
    });
    IPage<TzUgpTask> page;
    if (StringUtils.isBlank(pageNum)  ||StringUtils.isBlank(pageSize)) {
        pageBean = new Page<>(0, Long.MAX_VALUE);
    }else{
        pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
    }
    page = iTzUgpTaskService.page(pageBean, tzUgpTaskQueryWrapper);
    return page;
  }
}


