package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.yeejoin.amos.boot.module.ugp.api.dto.*;
import com.yeejoin.amos.boot.module.ugp.api.service.IVerifyService;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.VerifyServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 智能监检管理表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@RestController
@Api(tags = "智能监检管理表Api")
@RequestMapping(value = "/verify")
public class VerifyController extends BaseController {

    @Autowired
    VerifyServiceImpl verifyServiceImpl;
    @Autowired
	IVerifyService service;

    /**
     * 新增智能监检管理表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增智能监检管理表", notes = "新增智能监检管理表")
	public ResponseModel<VerifyDto> save(@RequestBody VerifyDto model) {
	    model = verifyServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新智能监检管理表", notes = "根据sequenceNbr更新智能监检管理表")
	public ResponseModel<VerifyDto> updateBySequenceNbrVerify(@RequestBody VerifyDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(verifyServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除智能监检管理表", notes = "根据sequenceNbr删除智能监检管理表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(verifyServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个智能监检管理表",  notes = "根据sequenceNbr查询单个智能监检管理表")
	public ResponseModel<VerifyDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(verifyServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "智能监检管理表分页查询",  notes = "智能监检管理表分页查询")
	public ResponseModel<Page<VerifyDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<VerifyDto> page = new Page<VerifyDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(verifyServiceImpl.queryForVerifyPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "智能监检管理表列表全部数据查询",   notes = "智能监检管理表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<VerifyDto>> selectForList() {
	    return ResponseHelper.buildResponse(verifyServiceImpl.queryForVerifyList());
	}










	/**   cpp
	 *
	 *焊接管材检验信息列表
	 * @param current
	 * @param size
	 * @param dto
	 * @return
	 */

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/selectInspection")
	@ApiOperation(httpMethod = "GET", value = "焊接管材检验信息列表", notes = "焊接管材检验信息列表")
	public ResponseModel<Page<TubingDto>> selectInspection(@RequestParam(value = "current") int current, @RequestParam
			(value = "size") int size, TubingDto dto) {
		Page<TubingDto> page = new Page<>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(service.selectInspection(page,dto));
	}


	/**   cpp
	 *
	 *查询焊接人员检验信息列表
	 * @param current
	 * @param size
	 * @param dto
	 * @return
	 */

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/selectWorker")
	@ApiOperation(httpMethod = "GET", value = "查询焊接人员检验信息列表", notes = "查询焊接人员检验信息列表")
	public ResponseModel<Page<WorkerDto>> selectWorker(@RequestParam(value = "current") int current, @RequestParam
			(value = "size") int size, WorkerDto dto) {
		Page<WorkerDto> page = new Page<>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(service.selectWorker(page,dto));
	}

	/**   cpp
	 *
	 *查询焊接设备检验信息列表
	 * @param current
	 * @param size
	 * @param dto
	 * @return
	 */

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/selectFacility")
	@ApiOperation(httpMethod = "GET", value = "查询焊接设备检验信息列表", notes = "查询焊接设备检验信息列表")
	public ResponseModel<Page<FacilityDto>> selectFacility(@RequestParam(value = "current") int current, @RequestParam
			(value = "size") int size, FacilityDto dto) {
		Page<FacilityDto> page = new Page<>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(service.selectFacility(page,dto));
	}







	/**
	 *  cpp
	 *
	 *    校验
	 * @param dto
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@PostMapping(value = "/checks")
	@ApiOperation(httpMethod = "POST", value = "校验app上传数据", notes = "校验app上传数据")
	public ResponseModel<String> checks(@RequestBody AcceptDto dto) {
		return ResponseHelper.buildResponse(verifyServiceImpl.checks(dto));
	}



}
