package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.ugp.api.entity.Weld;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.List;

import com.yeejoin.amos.boot.module.ugp.biz.service.impl.WeldServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.WeldDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 焊口信息表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@RestController
@Api(tags = "焊口信息表Api")
@RequestMapping(value = "/weld")
public class WeldController extends BaseController {

    @Autowired
    WeldServiceImpl weldServiceImpl;

    /**
     * 新增焊口信息表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增焊口信息表", notes = "新增焊口信息表")
    public ResponseModel<WeldDto> save(@RequestBody WeldDto model) {
        model = weldServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新焊口信息表", notes = "根据sequenceNbr更新焊口信息表")
    public ResponseModel<WeldDto> updateBySequenceNbrWeld(@RequestBody WeldDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(weldServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除焊口信息表", notes = "根据sequenceNbr删除焊口信息表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(weldServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个焊口信息表", notes = "根据sequenceNbr查询单个焊口信息表")
    public ResponseModel<WeldDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(weldServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询+条件查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "焊口信息表分页查询", notes = "焊口信息表分页查询")
    public ResponseModel<Page<WeldDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size) {

        return ResponseHelper.buildResponse(weldServiceImpl.queryForWeldPage(current, size));
    }

    /**
     * 更新焊口编码任务状态
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/updateTask")
    @ApiOperation(httpMethod = "GET", value = "更新焊口编码任务状态", notes = "更新焊口编码任务状态")
    public ResponseModel<String> updateTask(Weld weld) {

        return ResponseHelper.buildResponse(weldServiceImpl.updateTask(weld));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "焊口信息表列表全部数据查询", notes = "焊口信息表列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<WeldDto>> selectForList() {
        return ResponseHelper.buildResponse(weldServiceImpl.queryForWeldList());
    }

    /**
     * 生成焊口编码
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "生成焊口编码", notes = "生成焊口编码")
    @GetMapping(value = "/getCode")
    public ResponseModel<List<Weld>> getCode(Long sequenceNbr, int number) {

        return ResponseHelper.buildResponse(weldServiceImpl.getCode(sequenceNbr,number));
    }

}
