package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ugp.api.dto.WelderDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.Project;
import com.yeejoin.amos.boot.module.ugp.api.mapper.ProjectMapper;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.OrgServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@Api(tags = "焊工信息")
@RequestMapping(value = "/welder")
public class WelderController extends BaseController {
    @Autowired
    OrgServiceImpl orgService;
    @Autowired
    ProjectMapper projectMapper;


    /**
     * 新增焊工信息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/saveWelder", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增焊工信息", notes = "新增焊工信息")
    public ResponseModel<Object> saveWelder(@RequestParam String isWelder, @RequestBody WelderDto welderDto) {

        return ResponseHelper.buildResponse(null);
    }

    /**
     * 获取焊工信息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/selectWelder")
    @ApiOperation(httpMethod = "GET", value = "新增焊工信息", notes = "新增焊工信息")
    public ResponseModel<List<JSONObject>> selectWelder(@RequestParam("code") String code) {
        List<JSONObject> jsonObjectList=new ArrayList<>();
        LambdaQueryWrapper<Project> wrapper=new LambdaQueryWrapper<>();
        wrapper.eq(Project::getCode,code);
        Project project = projectMapper.selectOne(wrapper);
        List<Map> info = orgService.getInfo(String.valueOf(project.getCompanyId()));
        for (Map<String,Object> map:info){
            JSONObject jsonObject=new JSONObject();
            jsonObject.put("name",map.get("name"));
            jsonObject.put("sequenceNbr",map.get("sequenceNbr"));
            jsonObjectList.add(jsonObject);
        }

        return ResponseHelper.buildResponse(jsonObjectList);
    }

}
