package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.yeejoin.amos.boot.module.ugp.api.dto.InstallNoticePageDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.InstallNotice;
import com.yeejoin.amos.boot.module.ugp.api.mapper.InstallNoticeMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IInstallNoticeService;
import com.yeejoin.amos.boot.module.ugp.api.dto.InstallNoticeDto;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.sql.Wrapper;
import java.util.List;

/**
 * 安装告知表服务实现类
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Service
public class InstallNoticeServiceImpl extends BaseService<InstallNoticeDto,InstallNotice,InstallNoticeMapper> implements IInstallNoticeService{

    @Autowired
    InstallNoticeMapper installNoticeMapper;
    /**
     * 分页查询
     */
    public Page<InstallNoticeDto> queryForInstallNoticePage(Page<InstallNoticeDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<InstallNoticeDto> queryForInstallNoticeList()   {
        return this.queryForList("" , false);
    }

    /**
     * 安装告知申请分页查询
     */
    public Page<InstallNoticePageDto> installNoticePage(Page<InstallNoticePageDto> page,String name,String constructionUnit)   {
        return installNoticeMapper.installNoticePage(page,name,constructionUnit);
    }

    /**
     * 安装告知申请列表查询
     */
    @Override
    public List<InstallNoticePageDto> installNoticeList()   {
        return installNoticeMapper.installNoticeList();
    }
    /**
     * 安装告知申请列表按name,unit筛选
     */
    @Override
    public List<InstallNoticePageDto> selectByName(String name, String unit) {
        return installNoticeMapper.selectByName(name,unit);
    }

    /**
     *通过sequenceNbr查列表数据
     */
    @Override
    public InstallNoticePageDto selectById(Long sequenceNbr) {

        return installNoticeMapper.selectById(sequenceNbr);
    }

    /**
     * 根据sequenceNbr查询告知申请详情
     * @param sequenceNbr
     * @return
     */
    public InstallNoticeDto selectOneById(Long sequenceNbr){
        return installNoticeMapper.selectoneById(sequenceNbr);
    }
}