package com.yeejoin.amos.boot.module.ugp.biz.service.impl;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.QueryChainWrapper;
import com.yeejoin.amos.boot.module.ugp.api.Enum.StageEnum;
import com.yeejoin.amos.boot.module.ugp.api.dto.BeforeDto;
import com.yeejoin.amos.boot.module.ugp.api.dto.IntelligentInspectionDto;
import com.yeejoin.amos.boot.module.ugp.api.dto.WeldDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.Project;
import com.yeejoin.amos.boot.module.ugp.api.entity.Verify;
import com.yeejoin.amos.boot.module.ugp.api.mapper.IntelligentInspectionMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IIntelligentInspectionService;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @Author cpp
 * @Description
 * @Date 2022/10/13
 */
@Service
public class IntelligentInspectionServiceImpl  extends BaseService<IntelligentInspectionDto, Verify, IntelligentInspectionMapper> implements IIntelligentInspectionService {

 @Autowired
 private IntelligentInspectionMapper mapper;


    /**
     * 校检阶段公共方法
     * name: 那个阶段
     */

    public   JSONArray commonality(String  name){
        List<Verify> commonality = mapper.commonality();
        if (!StringUtils.isEmpty(name)) {

            if (name.equals(StageEnum.焊前.getName())) {

                //进入焊前

                List<BeforeDto> beforeDtoList =new ArrayList<>();
                //获取项目信息
                for (Verify verify : commonality) {
                    BeforeDto beforeDto = new BeforeDto( );
                    beforeDto.setProjectId(verify.getProjectId());  //项目id
                    beforeDto.setName(verify.getProject().getName());//项目名称
                    beforeDto.setProjectCode(verify.getProject().getCode());//项目编号
                    beforeDto.setStatus(verify.getStatus());//检验状态
                    beforeDto.setType(verify.getType());//检验方式
                    beforeDto.setSubmitTime(verify.getVerifyTime());//交检日期
                    beforeDto.setVerifyTime(verify.getVerifyTime());//检验时间


                    String targetInfo = verify.getTargetInfo( );//app上传数据

                    //塞数据(焊口编码,管材厂家,管材批号,质量许可,焊工编号,管材验证定位信息,检验检测单位,检验负责人,监检员)

                    beforeDtoList.add(beforeDto);

                }
                JSONArray jsonArray = JSONArray.parseArray(JSON.toJSONString(beforeDtoList));
                return jsonArray ;

            }else if (name.equals(StageEnum.工艺.getName())) {
                //进入工艺
                return null;

            }else if (name.equals(StageEnum.耐压.getName()) ) {
                //进入耐压

                return null;

            }else if (name.equals(StageEnum.敷设.getName())) {
                //进入敷压
                return null;
            }else if (name.equals(StageEnum.定位.getName()) ){
                //进入定位
                return null;

            }

        }

        return null;
    }








    /**
     * 查询焊接管材检验信息列表
     * @param page
     * @param dto
     * @return
     */
    @Override
    public Page<BeforeDto> selectInspection(Page<BeforeDto> page, BeforeDto dto) {

        JSONArray commonality = this.commonality("BEFORE-WELDING");
        List<BeforeDto> beforeDtoList = JSONObject.parseArray(commonality.toJSONString( ), BeforeDto.class);
        page.setRecords(beforeDtoList);
        page.setTotal(beforeDtoList.size());


        return page;
    }



}
