package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.MaterialDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.Equipment;
import com.yeejoin.amos.boot.module.ugp.api.entity.Material;
import com.yeejoin.amos.boot.module.ugp.api.mapper.MaterialMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IMaterialService;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.ArrayList;
import java.util.List;

/**
 * 材料信息表服务实现类
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Service
public class MaterialServiceImpl extends BaseService<MaterialDto, Material, MaterialMapper> implements IMaterialService {
    /**
     * 分页查询
     */
    public Page<MaterialDto> queryForMaterialPage(Page<MaterialDto> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<MaterialDto> queryForMaterialList() {
        return this.queryForList("", false);
    }


    /**
     * 获取材料名称跟企业id
     */
    public List<JSONObject> selectName(String installationUnitId) {
        List<JSONObject> names = new ArrayList<>();
        //添加查询条件
        QueryWrapper<Material> wrapper = new QueryWrapper<>();
        wrapper.eq("company_id", installationUnitId);

        List<Material> materials = baseMapper.selectList(wrapper);

        for (Material i : materials) {
            JSONObject name = new JSONObject();
            name.put("name", i.getName());
            name.put("SequenceNbr", i.getSequenceNbr());
            names.add(name);
        }

        return names;
    }
}