package com.yeejoin.amos.boot.module.ugp.biz.service.impl;
import com.yeejoin.amos.boot.module.ugp.api.Enum.StageEnum;
import com.yeejoin.amos.boot.module.ugp.api.dto.*;
import com.yeejoin.amos.boot.module.ugp.api.entity.Verify;
import com.yeejoin.amos.boot.module.ugp.api.mapper.VerifyMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IVerifyService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.ArrayList;
import java.util.List;

/**
 * 智能监检管理表服务实现类
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Service
public class VerifyServiceImpl extends BaseService<VerifyDto,Verify,VerifyMapper> implements IVerifyService {
    /**
     * 分页查询
     */
    public Page<VerifyDto> queryForVerifyPage(Page<VerifyDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<VerifyDto> queryForVerifyList()   {
        return this.queryForList("" , false);
    }







@Autowired
private  VerifyMapper verifyMapper;
    /**
     * 智能监检共用查询方法
     *
     */
    public List<IntelligentInspectionDto> commonality(String stage){

        List<Verify> commonality = verifyMapper.commonality(stage);
        List<IntelligentInspectionDto> dtoList =new ArrayList<>();
                //进入焊前
                if (commonality !=null && commonality.size() !=0){

                    for (Verify verify : commonality) {
                        IntelligentInspectionDto beforeDto = new IntelligentInspectionDto( );
                        beforeDto.setSequenceNbr(verify.getSequenceNbr());//智能监检表id
                        beforeDto.setProjectId(verify.getProjectId());  //项目id
                        beforeDto.setName(verify.getProject().getName());//项目名称
                        beforeDto.setProjectCode(verify.getProject().getCode());//项目编号
                        beforeDto.setStatus(verify.getStatus());//检验状态
                        beforeDto.setType(verify.getType());//检验方式
                        beforeDto.setSubmitTime(verify.getVerifyTime());//交检日期
                        beforeDto.setVerifyTime(verify.getVerifyTime());//检验时间
                        beforeDto.setStage(verify.getStage());
                        String targetInfo = verify.getTargetInfo();//app上传数据
                        beforeDto.setTargetInfo(targetInfo);
                        dtoList.add(beforeDto);
                    }
                }

                return dtoList ;
    }




    /**
     * 查询焊接管材检验信息列表
     * @param page
     * @param dto
     * @return
     */
    @Override
    public Page<TubingDto> selectInspection(Page<TubingDto> page, TubingDto dto) {

        List<IntelligentInspectionDto> commonality = this.commonality(StageEnum.焊前管材质量.getName());
        ArrayList<TubingDto> list = new ArrayList<>( );
        for (IntelligentInspectionDto intelligentInspectionDto : commonality) {
            TubingDto tubingDto = new TubingDto( );
            BeanUtils.copyProperties(intelligentInspectionDto,tubingDto);
            list.add(tubingDto);
        }
        page.setRecords(list);
        page.setTotal(list.size());
        return page;
    }



    /**
     * 查询焊接人员检验信息列表
     * @param page
     * @param dto
     * @return
     */
    @Override
    public Page<WorkerDto> selectWorker(Page<WorkerDto> page, WorkerDto dto) {

        List<IntelligentInspectionDto> commonality = this.commonality(StageEnum.焊前人员.getName());
        ArrayList<WorkerDto> workerList = new ArrayList<>( );
        for (IntelligentInspectionDto intelligentInspectionDto : commonality) {
            WorkerDto workerDto = new WorkerDto( );
            BeanUtils.copyProperties(intelligentInspectionDto,workerDto);
            workerList.add(workerDto);
        }
        page.setRecords(workerList);
        page.setTotal(workerList.size());
        return page;
    }





    /**
     * 查询焊接设备检验信息列表
     * @param page
     * @param dto
     * @return
     */
    @Override
    public Page<FacilityDto> selectFacility(Page<FacilityDto> page, FacilityDto dto) {

        List<IntelligentInspectionDto> commonality = this.commonality(StageEnum.焊前设备.getName());
        ArrayList<FacilityDto> facilityList = new ArrayList<>( );
        for (IntelligentInspectionDto intelligentInspectionDto : commonality) {
            FacilityDto facilityDto = new FacilityDto( );
            BeanUtils.copyProperties(intelligentInspectionDto,facilityDto);
            facilityList.add(facilityDto);
        }
        page.setRecords(facilityList);
        page.setTotal(facilityList.size());
        return page;
    }

    /**
     * 智能监检校验数据
     * @param dto
     * @return
     */
    public String checks(AcceptDto dto) {
        if (dto != null) {
            // 校验数据
         
            //调用方法判断


            //通过,将数据添加到verity表中,并返回ok


            //如果不通过，将出现问题的哪一个阶段存入tz_ugp_quality_problem表中,返回失败

        }


        return "ok";


    }
}