package com.yeejoin.amos.boot.module.elevator.flc.biz.controller;

import com.yeejoin.amos.boot.biz.common.annotation.ResubmitCheck;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.elevator.flc.biz.service.impl.CylinderFillingUnloadDataServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.elevator.flc.api.dto.CylinderFillingUnloadDataDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 气瓶充卸统计表
 *
 * @author system_generator
 * @date 2022-03-09
 */
@RestController
@Api(tags = "气瓶充卸统计表Api")
@RequestMapping(value = "/cylinder-filling-unload-data")
public class CylinderFillingUnloadDataController extends BaseController {

    @Autowired
    CylinderFillingUnloadDataServiceImpl cylinderFillingUnloadDataServiceImpl;

    /**
     * 新增气瓶充卸统计表
     *
     * @return
     */
	@ResubmitCheck
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增气瓶充卸统计表", notes = "新增气瓶充卸统计表")
	public ResponseModel<CylinderFillingUnloadDataDto> save(@RequestBody CylinderFillingUnloadDataDto model) {
	    model = cylinderFillingUnloadDataServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新气瓶充卸统计表", notes = "根据sequenceNbr更新气瓶充卸统计表")
	public ResponseModel<CylinderFillingUnloadDataDto> updateBySequenceNbrCylinderFillingUnloadData(@RequestBody CylinderFillingUnloadDataDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(cylinderFillingUnloadDataServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除气瓶充卸统计表", notes = "根据sequenceNbr删除气瓶充卸统计表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(cylinderFillingUnloadDataServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个气瓶充卸统计表",  notes = "根据sequenceNbr查询单个气瓶充卸统计表")
	public ResponseModel<CylinderFillingUnloadDataDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(cylinderFillingUnloadDataServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "气瓶充卸统计表分页查询",  notes = "气瓶充卸统计表分页查询")
	public ResponseModel<Page<CylinderFillingUnloadDataDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<CylinderFillingUnloadDataDto> page = new Page<CylinderFillingUnloadDataDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(cylinderFillingUnloadDataServiceImpl.queryForCylinderFillingUnloadDataPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "气瓶充卸统计表列表全部数据查询",   notes = "气瓶充卸统计表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<CylinderFillingUnloadDataDto>> selectForList() {
	    return ResponseHelper.buildResponse(cylinderFillingUnloadDataServiceImpl.queryForCylinderFillingUnloadDataList());
	}
}
