package com.yeejoin.amos.patrol.business.param;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.patrol.common.enums.MsgTypeEnum;

import java.util.Date;
import java.util.List;

public class NoticePublishParam {

	/**
	 * 通知标题（"通知公告"）
	 */
	private String title = MsgTypeEnum.NOTIFY.getName();
	
	/**
	 * 通知内容
	 */
	private String body;
	
	/**
	 * 接收人id
	 */
	private List<String> userId;
	
	/**
	 * 是否立即发送
	 */
	private boolean isImmediately;
	
	/**
	 * 定点发送时间
	 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date fixedTime;
    
    /**
	 * 创建者
	 */
	private String createBy;

	/**
	 * 创建者
	 */
	private String userName;
    
    private String orgCode;


	//单位code
	private String bizOrgCode;

	//单位名称
	private String bizOrgName;

	public String getBizOrgCode() {
		return bizOrgCode;
	}

	public void setBizOrgCode(String bizOrgCode) {
		this.bizOrgCode = bizOrgCode;
	}

	public String getBizOrgName() {
		return bizOrgName;
	}

	public void setBizOrgName(String bizOrgName) {
		this.bizOrgName = bizOrgName;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public List<String> getUserId() {
		return userId;
	}

	public void setUserId(List<String> userId) {
		this.userId = userId;
	}

	public boolean getIsImmediately() {
		return isImmediately;
	}

	public void setIsImmediately(boolean isImmediately) {
		this.isImmediately = isImmediately;
	}

	public Date getFixedTime() {
		return fixedTime;
	}

	public void setFixedTime(Date fixedTime) {
		this.fixedTime = fixedTime;
	}

	public String getCreateBy() {
		return createBy;
	}

	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}
}
