package com.yeejoin.amos.boot.module.elevator.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.elevator.api.dto.RescueStationDto;
import com.yeejoin.amos.boot.module.elevator.api.entity.RescueStation;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
*  Mapper 接口
*
* @author tb
* @date 2021-06-01
*/
public interface RescueStationMapper extends BaseMapper<RescueStation> {
    /**
     * 根据经纬度和距离反馈救援机构列表
     * @param lat
     * @param lon
     * @param distance 单位为千米
     * @return
     */
    List<RescueStationDto> getListByLatLonDistance(String lat, String lon, Integer distance);

    List<RescueStationDto> selectExportData(@Param("ids") List<String> ids);

    IPage<RescueStation> getRescueStationList(@Param("page") IPage<RescueStation> page,@Param("dto") RescueStationDto dto);

    Map<String, Object> getDetailById(@Param("id") Long id);
}
