package com.yeejoin.amos.boot.module.jg.api.mapper;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.jg.api.dto.CompanyEquipCountDto;
import com.yeejoin.amos.boot.module.jg.api.dto.EquipBizCountDto;
import com.yeejoin.amos.boot.module.jg.api.dto.JgUseRegistrationDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistration;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import com.yeejoin.amos.boot.module.jg.api.vo.tableDataExportVo.RegistrationVo;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Mapper 接口
 *
 * @author system_generator
 * @date 2023-12-12
 */
public interface JgUseRegistrationMapper extends BaseMapper<JgUseRegistration> {

    Page<Map<String, Object>> getListPage(@Param("page") Page<Map<String, Object>> page,
                                          @Param("sort") SortVo sortMap,
                                          @Param("dto") JgUseRegistrationDto dto,
                                          @Param("roleIds") List<String> roleIds,
                                          @Param("client") String client);

    List<RegistrationVo> queryRegistrationInIds(@Param("dto") JgUseRegistrationDto dto,
                                                @Param("client") String client);

    Map<String, Object> getDetail(@Param("id") String id);

    Map<String, Object> getSupervisionInfoDetail(@Param("id") String id);

    Map<String, Object> getInspectDetail(@Param("id") String id, @Param("permissionInspectTypes") List<String> permissionInspectTypes);

    Map<String, Object> getUseDetail(@Param("id") String id);

    Map<String, Object> getDesDetail(@Param("id") String id);

    Map<String, Object> getInspectDetailByRecord(@Param("id") String id);

    Page<Map<String, Object>> getEquipListPage(@Param("page") Page<Map<String, Object>> page, @Param("factoryNum") String factoryNum, @Param("equList") String equList, @Param("equCategory") String equCategory);

    void updatePromoter(@Param("id") Long id);

    List<Map<String, Object>> getDetailById(@Param("id") Long id);

    String getEquType(@Param("record") String record);

    Map<String, Object> getMaintenanceDetail(@Param("id") String id);

    Map<String, Object> getMaintenanceDetailByIdx(@Param("id") String id);

    Map<String, Object> getiInstallDetail(@Param("id") String id);

    Map<String, Object> getiInstallDetailByIdx(@Param("id") String id);

    Map<String, Object> getUseRegistrationDetail(@Param("id") String id);

    Page<JSONObject> queryForUnitVesselEquipmentPage(@Param("page") Page<JSONObject> page, @Param("jsonObject") JSONObject jsonObject, @Param("records") Set<String> records);

    Page<JSONObject> queryForEquipUsedByVehiclePage(@Param("page") Page<JSONObject> page, @Param("jsonObject") JSONObject jsonObject);

    Page<JSONObject> queryForEquipUsedByVehiclePageHistory(@Param("page") Page<JSONObject> page, @Param("jsonObject") JSONObject jsonObject);

    @MapKey("records")
    List<Map<String, Object>> queryForUnitVesselEquipment(@Param("records") List<String> records);

    Page<JSONObject> queryForUnitPipelineEquipmentPage(@Param("page") Page<JSONObject> page, @Param("jsonObject") JSONObject jsonObject, @Param("records") Set<String> records);

    @MapKey("records")
    List<Map<String, Object>> queryForUnitPipelineEquipment(@Param("records") List<String> records);

    List<Map<String, Object>> queryForUnitPipelineEquipmentForEdit(@Param("records") List<String> records);

    @MapKey("id")
    List<Map<String, Object>> selectEquipList(@Param("id") Long id);

    List<CompanyEquipCountDto> queryForFlowingEquipList();

    Map<String,String> getEquTypeByUseRegSeq(@Param("sequenceNbr")String sequenceNbr);

    Map<String,String> getEquTypeByVehSeq(@Param("sequenceNbr")String sequenceNbr);

    @Select("select name from tz_equipment_category where code=#{code}")
    String getEquCategoryNameByCode(String code);

    List<EquipBizCountDto> queryNewDeviceStaticListData(DPFilterParamDto dpFilterParamDto);

    Integer getUseRegisterCount(@Param("dpFilterParamDto") DPFilterParamDto dpFilterParamDto);

    List<Map<String, Object>> getElevatorModeList(@Param("equIds") List<String> equIds);

    List<Map<String, Object>> getCylinderInfoList(@Param("records") List<String> records);


    /**
     * 批量更新 CYLINDER_CATEGORY 根据 equCode
     *
     * @param cylinderCategory 需要更新的参数列表
     * @param equCodeList equCode列表
     * @return 更新成功返回 true，失败返回 false
     */
    Boolean updateByEquCodeList(@Param("cylinderCategory") String cylinderCategory, @Param("equCodeList") List<String> equCodeList);

    List<Map> stopStateCount(@Param("orgCode") String orgCode);

    List<Map> cancelStateCount(@Param("orgCode") String orgCode, @Param("cancelType") int cancelType);

    /**
     * 查询指定装置下可做使用登记的的管道，样式为汇总表样式
     * @param projectContraptionSeq 装置id
     * @return List<Map<String, Object>>
     */
    List<Map<String, Object>> selectPieLineListByOfCanReg(@Param("projectContraptionSeq") String projectContraptionSeq);

}
