package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.yeejoin.amos.boot.module.jg.biz.service.impl.DataDockServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.io.FilenameUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

@Validated
@RestController
@Api(tags = "数据对接 API")
@RequestMapping(value = "/dataDock")
public class DataDockController {

    private final DataDockServiceImpl dataDockService;

    public DataDockController(DataDockServiceImpl dataDockService) {
        this.dataDockService = dataDockService;
    }

    /**
     * 西安数据对接-批量导入设备数据的接口
     *
     * @param equLists 设备数据集合
     * @return result
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/xi-an/saveEquipmentData")
    @ApiOperation(httpMethod = "POST", value = "西安数据对接-设备批量导入", notes = "西安数据对接-导入多个设备的数据文件")
    public ResponseModel<?> saveEquipmentData(@RequestBody List<Map<String, Object>> equLists) throws Exception {
        return ResponseHelper.buildResponse(dataDockService.xiAnSaveEquipmentData(equLists));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/importData")
    @ApiOperation(httpMethod = "POST", value = "八大类历史设备导入", notes = "八大类历史设备导入")
    public Object importData(@RequestParam String remark, @RequestParam MultipartFile file) {
        // 校验文件是否为空
        if (file.isEmpty()) {
            return ResponseHelper.buildResponse("文件不能为空");
        }
        // 校验文件类型为 Excel
        String contentType = file.getContentType();
        String fileExtension = FilenameUtils.getExtension(file.getOriginalFilename());
        // 校验 Excel 文件的 MIME type 和扩展名
        if (!("application/vnd.ms-excel".equals(contentType) ||
                "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(contentType)) ||
                !("xls".equalsIgnoreCase(fileExtension) || "xlsx".equalsIgnoreCase(fileExtension))) {
            return ResponseHelper.buildResponse("文件类型必须是 Excel 文件");
        }
        return ResponseHelper.buildResponse(dataDockService.dataCheckAndImportEquipmentData(remark, file));
    }

    // @TycloudOperation(ApiLevel = UserType.AGENCY)
    // @PostMapping(value = "/delete")
    // @ApiOperation(httpMethod = "POST", value = "八大类历史设备导入shanchu", notes = "八大类历史设备导入shachu")
    // public Object importData() {
    //     dataDockService.delete();
    //     return ResponseHelper.buildResponse("ok");
    // }

    // @TycloudOperation(ApiLevel = UserType.AGENCY)
    // @GetMapping(value = "/yanChang/ORG_BRANCH_CODE")
    // @ApiOperation(httpMethod = "get", value = "延炼-延长-刷入属地监管部门", notes = "延炼-延长-刷入属地监管部门")
    // public Object writeOrgBranchCode2YanChang(@NotNull @RequestParam String remark) {
    //     if (ValidationUtil.isEmpty(remark)) {
    //         throw new BadRequest("remark必填！");
    //     }
    //     return ResponseHelper.buildResponse("更新成功，共" + dataDockService.writeOrgBranchCode2YanChang(remark) + "条数据");
    // }
}

