package com.yeejoin.amos.boot.module.ymt.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 使用信息表
 *
 * @author system_generator
 * @date 2023-08-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="IdxBizJgUseInfoDto", description="使用信息表")
public class IdxBizJgUseInfoDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @TableField("RECORD")
    private String record;

    @TableField("INSTANCE_ID")
    private String instanceId;

    @TableField("STATUS")
    private String status;

    @ApiModelProperty(value = "使用单位统一信用代码")
    @TableField("USE_UNIT_CREDIT_CODE")
    private String useUnitCreditCode;

    @ApiModelProperty(value = "使用单位名称")
    @TableField("USE_UNIT_NAME")
    private String useUnitName;

    @ApiModelProperty(value = "产权单位统一信用代码")
    @TableField("ESTATE_UNIT_CREDIT_CODE")
    private String estateUnitCreditCode;

    @ApiModelProperty(value = "产权单位名称")
    @TableField("ESTATE_UNIT_NAME")
    private String estateUnitName;

    @ApiModelProperty(value = "使用状态变更日期")
    @TableField("USE_STATE_CHANGE_DATE")
    private String useStateChangeDate;

    @ApiModelProperty(value = "变更事项")
    @TableField("CHANGES")
    private String changes;

    @ApiModelProperty(value = "使用内部编号")
    @TableField("USE_INNER_CODE")
    private String useInnerCode;

    @ApiModelProperty(value = "投入使用日期")
    @TableField("USE_DATE")
    private String useDate;

    @ApiModelProperty(value = "经办人")
    @TableField("AGENT")
    private String agent;

    @ApiModelProperty(value = "设备使用地点-省")
    @TableField("PROVINCE")
    private String province;

    @ApiModelProperty(value = "设备使用地点-市")
    @TableField("CITY")
    private String city;

    @ApiModelProperty(value = "设备使用地点-区（县）")
    @TableField("COUNTY")
    private String county;

    @ApiModelProperty(value = "设备使用地点-街道（镇）")
    @TableField("FACTORY_USE_SITE_STREET")
    private String factoryUseSiteStreet;

    @ApiModelProperty(value = "设备详细使用地址")
    @TableField("ADDRESS")
    private String address;

    @ApiModelProperty(value = "设备地理坐标经纬度")
    @TableField("LONGITUDE_LATITUDE")
    private String longitudeLatitude;

    @ApiModelProperty(value = "设备使用场所")
    @TableField("USE_PLACE")
    private String usePlace;

    @ApiModelProperty(value = "设备主管部门")
    @TableField("EQU_MANAGE_DT")
    private String equManageDt;

    @ApiModelProperty(value = "安全管理部门名称")
    @TableField("SAFETY_MANAGE_DT")
    private String safetyManageDt;

    @ApiModelProperty(value = "安全管理员")
    @TableField("SAFETY_MANAGER")
    private String safetyManager;

    @ApiModelProperty(value = "安全管理员移动电话")
    @TableField("PHONE")
    private String phone;

    @ApiModelProperty(value = "设备状态")
    @TableField("EQU_STATE")
    private String equState;

    @TableField("PROVINCE_NAME")
    private String provinceName;

    @TableField("CITY_NAME")
    private String cityName;

    @TableField("COUNTY_NAME")
    private String countyName;

    @ApiModelProperty(value = "是否同步到es中")
    @TableField("IS_NOT_ES")
    private String isNotEs;

    @ApiModelProperty(value = "是否同步ELEV到es中")
    @TableField("IS_NOT_ELEV")
    private String isNotElev;


    @ApiModelProperty(value = "历史设备-原使用登记证附件")
    @TableField("\"OLD_USE_REGISTRATION_CERTIFICATE\"")
    private String oldUseRegistrationCertificate;


    @ApiModelProperty(value = "历史设备-原使用登记表附件")
    @TableField("\"OLD_USE_REGISTRATION_TABLE\"")
    private String oldUseRegistrationTable;

}
