package com.yeejoin.amos.api.openapi.controller;

import com.yeejoin.amos.api.openapi.face.dto.JyjcInspectionResultDataModel;
import com.yeejoin.amos.api.openapi.face.dto.PipelineInspectionResultDto;
import com.yeejoin.amos.api.openapi.feign.JyjcServiceFeignClient;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * 特种设备监管controller
 *
 * @author Administrator
 */
@RestController
@Api(tags = "检验检测Api")
@RequestMapping(value = "/inspection")
public class JyjcController {

    @Autowired
    JyjcServiceFeignClient jyjcServiceFeignClient;

    /**
     * 设备定义列表数据查询
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/result-submit")
    @ApiOperation(httpMethod = "POST", value = "非压力管道-检验检测结果回传", notes = "非压力管道-检验检测结果回传")
    public ResponseModel<List<JyjcInspectionResultDataModel>> resultSubmit(@RequestBody List<JyjcInspectionResultDataModel> resultDataModels) {
        return jyjcServiceFeignClient.saveResultDataBatch(resultDataModels);
    }

    /**
     * 设备定义列表数据查询
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/pipeline/result-submit")
    @ApiOperation(httpMethod = "POST", value = "压力管道-检验检测结果回传", notes = "压力管道-检验检测结果回传")
    public ResponseModel<List<PipelineInspectionResultDto>> pipelineResultSubmit(@RequestBody List<PipelineInspectionResultDto> resultDataModels) {
        return jyjcServiceFeignClient.savePipelineResultDataBatch(resultDataModels);
    }

}
