package com.yeejoin.amos.boot.module.tzs.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author litw
 * @date 2021-09-29.
 */
@Data
@ApiModel(value="ElevatorWlInfoDto", description="电梯物联信息")
public class ElevatorWlInfoDto {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     * 电梯id
     */
    @ApiModelProperty(value = "电梯id")
    private Long sequenceNbr;

    /**
     * 注册编码
     */
    @ApiModelProperty(value = "注册编码")
    private String registerCode;


    /**
     * 电梯识别码
     */
    @ApiModelProperty(value = "电梯识别码")
    private Integer rescueCode;
    /**
     * 地址
     */
    @ApiModelProperty(value = "地址")
    private String address;


    /**
     * 发生时间
     */
    @ApiModelProperty(value = "发生时间")
    private Date happenTime ;

    /**
     * 故障类型
     */
    @ApiModelProperty(value = "故障类型")
    private String type ;

    /**
     * 物联服务提供商
     */
    @ApiModelProperty(value = "物联服务提供商")
    private String IotServiceProvider ;

    /**
     * 处置状态
     */
    @ApiModelProperty(value = "处置状态")
    private String dealStatus ;

    /**
     * 设备种类
     */
    @ApiModelProperty(value = "设备种类")
    private String category ;

    /**
     * 区域
     */
    @ApiModelProperty(value = "区域")
    private String area ;

    /**
     * 设备种类临时
     */
    @ApiModelProperty(value = "设备种类临时")
    private String categoryName ;

    int page;

    int size;
}
