package com.yeejoin.amos.fas.business.dao.repository;

import com.yeejoin.amos.fas.dao.entity.PlanDoc;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * <h1><h1>
 *
 * @author tiantao
 * @date 2021/1/15 10:36
 */
@Repository
public interface IPlanDocDao extends BaseDao<PlanDoc, Long> {

    void deleteByPlanId(Long planId);

    List<PlanDoc> getPlanDocsByPlanId(Long planId);

    List<PlanDoc> findAllByPlanIdIn(List<Long> planId);

    List<PlanDoc> findAllByIsDelete(Boolean isDelete);

    @Query(value="SELECT * from c_plan_doc where plan_id in (?1) AND is_delete = 0 ", nativeQuery = true)
    List<PlanDoc> findAllByPlanId(Long planId);
}
