package com.yeejoin.amos.boot.module.tzs.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.tzs.api.service.TzsAuthService;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

/**
 * 特种设备权限controller
 */
@RestController
@Api(tags = "特种设备权限Api")
@RequestMapping(value = "/tzs-auth-api")
public class TzsAuthController extends BaseController {



	@Autowired
	TzsAuthService tzsAuthService;

	/**
	 * 判断用户是否是管理员
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/isUserAdmin")
	@ApiOperation(httpMethod = "GET", value = "判断用户是否是管理员", notes = "判断用户是否是管理员")
	public ResponseModel<Boolean> isUserAdmin() {
		Boolean flag = false;
		AgencyUserModel me = Privilege.agencyUserClient.getme().getResult();
		if(me.getUserName().equals("tzs_wjl")) {
			flag = true;
		}
		return ResponseHelper.buildResponse(flag);
	}


}
