package com.yeejoin.amos.boot.module.jg.biz.handler;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jg.api.event.SafetyProblemEvent;
import com.yeejoin.amos.boot.module.jg.api.event.handler.SafetyProblemEventHandler;
import org.springframework.stereotype.Component;

/**
 * WBBAEventHandler 类实现了 SafetyProblemEventHandler 接口，
 * 用于处理维保备案安全问题事件。
 */
@Component
public class WBBAEventHandler implements SafetyProblemEventHandler {

    /**
     * 处理安全问题事件。
     *
     * @param event 安全问题事件对象，包含事件的详细信息。
     *              该参数用于描述发生的安全问题事件。
     */
    @Override
    public void handle(SafetyProblemEvent event) {
        // 此处为处理安全问题事件的逻辑代码
        handleMaintenanceRecord(JSONObject.parseObject(event.getMessage().toString()));
    }

    private void handleMaintenanceRecord(JSONObject jsonObject) {
//        JSONArray maintenanceRecords = JSONArray.parseArray(String.valueOf(jsonObject));
    }
}

