package com.yeejoin.amos.boot.module.ymt.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 安全追溯-索道
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "IdxBizJgTechParamsRopewayDto", description = "安全追溯-索道")
public class IdxBizJgTechParamsRopewayDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @TableField("RECORD")
    private String record;


    @TableField("INSTANCE_ID")
    private String instanceId;

    @TableField("STATUS")
    private String status;

    @TableField("HORIZONTAL_DISTANCE")
    private String horizontalDistance;

    @ApiModelProperty(value = "支架数目")
    @TableField("SUPPORTS_COUNT")
    private Integer supportsCount;

    @ApiModelProperty(value = "斜长")
    @TableField("OBLIQUE_LENGTH")
    private String obliqueLength;

    @ApiModelProperty(value = "主电机型号和功率")
    @TableField("MAIN_MOTOR_MODEL_AND_POWER")
    private String mainMotorModelAndPower;

    @ApiModelProperty(value = "高差")
    @TableField("ALTITUDE_DIFFERENCE")
    private String altitudeDifference;

    @ApiModelProperty(value = "张紧油压（重锤）")
    @TableField("OIL_PRESSURE_HEAVY_HAMMER")
    private String oilPressureHeavyHammer;

    @ApiModelProperty(value = "张紧油压（油压）")
    @TableField("OIL_PRESSURE_OIL_PRESSURE")
    private String oilPressureOilPressure;

    @ApiModelProperty(value = "运量")
    @TableField("FREIGHT_VOLUME")
    private String freightVolume;

    @ApiModelProperty(value = "运载索")
    @TableField("CARRIER_LINE")
    private String carrierLine;

    @ApiModelProperty(value = "速度")
    @TableField("SPEED")
    private String speed;

    @ApiModelProperty(value = "承载索")
    @TableField("BEARING_CABLE")
    private String bearingCable;

    @ApiModelProperty(value = "索距")
    @TableField("CABLE_PITCH")
    private String cablePitch;

    @ApiModelProperty(value = "运载工具数量和类型")
    @TableField("NUMBER_AND_TYPE_OF_VEHICLES")
    private String numberAndTypeOfVehicles;

    @ApiModelProperty(value = "索引索")
    @TableField("TRACTION_ROPE")
    private String tractionRope;

    @ApiModelProperty(value = "平衡索")
    @TableField("BALANCE_CABLE")
    private String balanceCable;

    /**
     * 参数是否完整齐全：1-齐全；2-不齐全 【历史无证设备需要】
     */
    private String techParamIsComplete;

}
