package com.yeejoin.amos.boot.module.common.api.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 大屏筛选过滤对象
 *
 * @author Administrator
 */
@Data
public class DPFilterParamForDetailDto {
    /**
     * 区域
     */
    @NotBlank(message = "区域编码不能为空！")
    private String cityCode;

    /**
     * 机构
     */
    private String orgCode;

    /**
     * 业务类型
     */
    private String businessType;
    /**
     * 具体业务类型 例如：安装告知、维修告知等
     * code对应统计服务中的jgdp_businessType.json
     */
    private String businessTypeCode;

    /**
     * 时间筛选
     */
    private DPFilterParamForDateDto timeSearchOne;

    /**
     * 当前页
     */

    private int current = 1;

    /**
     * 每页大小
     */
    private int size = 20;

    /**
     * 左侧树选中值
     */
    private String treeValue;

    /**
     * 设备种类
     */
    private String equListCode;

    /**
     * 设备类别
     */
    private String equCategoryCode;
    private String equCategory;

    /**
     * 监管单位名称（接收单位/管辖机构）
     */
    private String superviseUnitName;

    /**
     * 监管单位名称（接收单位/管辖机构）
     */
    private String orgBranchCode;

    /**
     * 企业单位名称（发起单位/使用单位）
     */
    private String companyName;

    /**
     * 维保单位名称
     */
    private String maintenanceCompanyName;

    /**
     * 地市名称
     */
    private String regionName;

    /**
     * 报警类型code
     */
    private String typeCode;

    /**
     * 警情来源code
     */
    private String alertSourceCode;

    /**
     * 警情类型code
     */
    private String alertTypeCode;

    /**
     * 气瓶充装异常情况（0:正常，1：异常）
     */
    private String anomalyType;

    /**
     * 地址
     */
    private String address;

    /**
     * 业务状态
     */
    private String status;
    /**
     * 工单编号
     */
    private String workOrderNumber;
    /**
     * 接警人
     */
    private String recUserName;

    /**
     * 求援人
     */
    private String emergencyPerson;

    /**
     * 求援开始事件
     */
    private String emergencyStartTime;

    /**
     * 求援结束事件
     */
    private String emergencyEndTime;

    /**
     * 求援电话
     */
    private String emergencyCall;

    /**
     * 电梯识别码
     */
    private String deviceId;

    /**
     * 警情状态
     */
    private String alertStatus;

    /**
     * 处置环节
     */
    private String alertStage;

    /**
     * 检测结果
     */
    private String inspectionConclusion;
    /**
     * 发起单位
     */
    private String applicationUnitName;
    /**
     * 接受单位
     */
    private String inspectionUnitName;
    /**
     * 充装介质
     */
    private String fillingMedium;
    /**
     * 是否对接 0：未对接，1：已对接
     */
    private String isDock;

    /**
     * 检验状态0临期1超期
     */
    private String inspectionStatus;
    /**
     * 监管码状态0已赋码1未赋码
     */
    private String supervisionCodeStatus;

    /**
     * 下次检验日期
     */
    private List<String> nextInspectionDate;
    /**
     * 姓名
     */
    private String userName;
    /**
     * 手机号
     */
    private String phone;
    /**
     * 证件号码
     */
    private String certificateNum;

    /**
     * 使用多个单位
     */
    private String useUnitName;
    /**
     * 使用登记证
     */
    private String useOrgCode;
    /**
     * 96333码
     */
    private String code96333;
    /**
     * 监管码
     */
    private String supervisoryCode;
    /**
     * 所属地区
     */
    private String usePlace;
    /**
     * 设备状态
     */
    private String equState;
    /**
     * 信息化
     */
    private String informationSituation;
}
