package com.yeejoin.amos.boot.module.cylinder.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 用户信息表
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_user_info")
public class TzsUserInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 姓名
     */
    @TableField("name")
    private String name;


    /**
     * 证件类型
     */
    @TableField("certificate_type")
    private String certificateType;

    /**
     * 证件编号
     */
    @TableField("certificate_num")
    private String certificateNum;

    /**
     * 性别
     */
    @TableField("gender")
    private String gender;

    /**
     * 岗位
     */
    @TableField("post")
    private String post;

    /**
     * 联系电话
     */
    @TableField("phone")
    private String phone;

    /**
     * 出生日期
     */
    @TableField("birthday")
    private Date birthday;

    /**
     * 学历
     */
    @TableField("education")
    private String education;

    /**
     * 专业
     */
    @TableField("speciality")
    private String speciality;

    /**
     * 邮箱
     */
    @TableField("email")
    private String email;

    /**
     * 住址
     */
    @TableField("address")
    private String address;

    /**
     * 证件照片
     */
    @TableField(value = "identification")
    private String identification;


    /**
     * 账户名
     */
    @TableField("amos_user_name")
    private String amosUserName;

    /**
     * 单位名称
     */
    @TableField("unit_name")
    private String unitName;
    /**
     * 头像
     */
    @TableField(value = "profile")
    private String profile;


    /**
     * 平台账号id
     */
    @TableField("amos_user_id")
    private String amosUserId;
    /**
     * 二维码状态0异常1正常
     */
    @TableField("qr_code_state")
    private String qrCodeState;
}
