package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.UserBizByTCMServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @author Administrator
 */
@RestController
@RequestMapping(value = "/dp/biz-user")
@Api(tags = "大屏-人员-业务API")
public class UserBizController {
    @Resource
    private UserBizByTCMServiceImpl userBizByTCMService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getDetail")
    @ApiOperation(httpMethod = "GET", value = "详情", notes = "详情")
    public ResponseModel<Map<String, Object>> queryForPage(@RequestParam(value = "id") Long id) {
        return ResponseHelper.buildResponse(userBizByTCMService.getDetail(id));
    }
}
