package com.yeejoin.equipmanage.common.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@ApiModel(description = "树")
public class CommonTreeVo {

    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "编号")
    private String code;

    @ApiModelProperty(value = "父id")
    private Long parentId;

    @ApiModelProperty(value = "节点类型（单位、设备、建筑、区域）")
    private String nodeType;

    @ApiModelProperty(value = "图标")
    private String icon;

    @ApiModelProperty(value = "排序")
    private Integer sort;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "子集")
    private List<CommonTreeVo> children;

}
