package com.yeejoin.amos.boot.module.ugp.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.UgpMaterialServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.UgpMaterialDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 材料信息表
 *
 * @author system_generator
 * @date 2022-09-21
 */
@RestController
@Api(tags = "材料信息表Api")
@RequestMapping(value = "/ugp-material")
public class UgpMaterialController extends BaseController {

    @Autowired
    UgpMaterialServiceImpl ugpMaterialServiceImpl;

    /**
     * 新增材料信息表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增材料信息表", notes = "新增材料信息表")
	public ResponseModel<UgpMaterialDto> save(@RequestBody UgpMaterialDto model) {
	    model = ugpMaterialServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新材料信息表", notes = "根据sequenceNbr更新材料信息表")
	public ResponseModel<UgpMaterialDto> updateBySequenceNbrUgpMaterial(@RequestBody UgpMaterialDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(ugpMaterialServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除材料信息表", notes = "根据sequenceNbr删除材料信息表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(ugpMaterialServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个材料信息表",  notes = "根据sequenceNbr查询单个材料信息表")
	public ResponseModel<UgpMaterialDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(ugpMaterialServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "材料信息表分页查询",  notes = "材料信息表分页查询")
	public ResponseModel<Page<UgpMaterialDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<UgpMaterialDto> page = new Page<UgpMaterialDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(ugpMaterialServiceImpl.queryForUgpMaterialPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "材料信息表列表全部数据查询",   notes = "材料信息表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<UgpMaterialDto>> selectForList() {
	    return ResponseHelper.buildResponse(ugpMaterialServiceImpl.queryForUgpMaterialList());
	}
}
