package com.yeejoin.precontrol.common.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.precontrol.common.dto.BaseDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 违章项目对象
 *
 * @author Admin
 */
@Data
public class BadProjectVo extends BaseDto {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "项目名称")
    @Excel(name = "项目名称")
    private String name;
    @ApiModelProperty(value = "项目id")
    private Long projectId;
    @Excel(name = "项目编号")
    private String projectNum;
    @Excel(name = "联系电话")
    private String phone;
    @Excel(name = "经度")
    private String longitude;
    @Excel(name = "纬度")
    private String latitude;
    @ApiModelProperty(value = "项目经理")
    @Excel(name = "项目经理")
    private String manager;
    @ApiModelProperty(value = "地区")
    @Excel(name = "地区")
    private String region;
    @ApiModelProperty(value = "项目状态")
    @Excel(name = "项目状态")
    private String status;
    @ApiModelProperty(value = "违章系数")
    @Excel(name = "违章系数")
    private String scale;
    @ApiModelProperty(value = "违章数量")
    @Excel(name = "违章数量")
    private String count;
    @ApiModelProperty(value = "违章系数最小")
    @TableField(exist = false)
    private String minScale;
    @ApiModelProperty(value = "违章系数最大")
    @TableField(exist = false)
    private String maxScale;
    @ApiModelProperty(value = "项目人数")
    private String personCount;
    @TableField(exist = false)
    @ApiModelProperty(value = "违章数量排序")
    private Boolean countOrder; //false是倒序 true是正序
    @TableField(exist = false)
    @ApiModelProperty(value = "违章系数排序")
    private Boolean scaleOrder; //false是倒序 true是正序
}
