package com.yeejoin.amos.boot.module.jczs.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jczs.api.common.MobileLoginParam;
import com.yeejoin.amos.boot.module.jczs.api.service.ISafetyService;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;

/**
 * @Author cpp
 * @Description
 * @Date 2023/4/23
 */
@RestController
@RequestMapping(value = "/safe")
@Api(tags = "微信程序登录api")
public class SafetyController extends BaseController {

    @Autowired
    private ISafetyService iSafetyService;

    @ApiOperation(value = "移动端登录", notes = "移动端登录")
    @PostMapping(value = "/mobile/login")
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    public ResponseModel<Map<String, Object>> loginFromApp(@RequestBody MobileLoginParam param) {
        buildRequestContext();
        return ResponseHelper.buildResponse(iSafetyService.loginFromApp(param));
    }
    protected void buildRequestContext() {
        String token = getToken();
        String product = getProduct();
        String appKey = getAppKey();
        RequestContext.setToken(token);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
    }
    


}
