package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.JgCertificateChangeRecordDto;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgCertificateChangeRecordServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import java.util.List;

/**
 *
 * @author system_generator
 * @date 2024-07-03
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/jg-certificate-change-record")
public class JgCertificateChangeRecordController extends BaseController {

    @Autowired
    JgCertificateChangeRecordServiceImpl jgCertificateChangeRecordServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<JgCertificateChangeRecordDto> save(@RequestBody JgCertificateChangeRecordDto dto) {
		dto = jgCertificateChangeRecordServiceImpl.createWithModel(dto);
	    return ResponseHelper.buildResponse(dto);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<JgCertificateChangeRecordDto> updateBySequenceNbrJgCertificateChangeRecord(@RequestBody JgCertificateChangeRecordDto dto,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    dto.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(jgCertificateChangeRecordServiceImpl.updateWithModel(dto));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(jgCertificateChangeRecordServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<JgCertificateChangeRecordDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(jgCertificateChangeRecordServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<JgCertificateChangeRecordDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
                    (value = "size") int size) {
	    Page<JgCertificateChangeRecordDto> page = new Page<JgCertificateChangeRecordDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(jgCertificateChangeRecordServiceImpl.queryForJgCertificateChangeRecordPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<JgCertificateChangeRecordDto>> selectForList() {
	    return ResponseHelper.buildResponse(jgCertificateChangeRecordServiceImpl.queryForJgCertificateChangeRecordList());
	}
}
