package com.yeejoin.amos.boot.module.statistics.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.*;

@AllArgsConstructor
@Getter
public enum CylinderCategoryEnum {
    /**
     * 气瓶分类枚举
     */
    yhsyqp("0", "液化石油气瓶"),
    gyqp("1", "工业气瓶"),
    qt("2", "其他");

    private String code;

    private String name;

    public static String getName(String code) {
        Optional<String> op = Arrays.stream(CylinderCategoryEnum.values()).filter(e -> e.getCode().equals(code)).map(CylinderCategoryEnum::getName).findFirst();
        return op.orElse("");
    }

    public static List<Map<String, Object>> getEnumList() {
        List<Map<String, Object>> list = new ArrayList<>();
        for (CylinderCategoryEnum testEnum : EnumSet.allOf(CylinderCategoryEnum.class)) {
            HashMap<String, Object> map = new HashMap<>();
            map.put("name", testEnum.name);
            map.put("code", testEnum.code);
            list.add(map);
        }
        return list;
    }


}
