package com.yeejoin.amos.boot.module.tcm.flc.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 液化气体气瓶充装信息审核
 *
 * @author system_generator
 * @date 2022-03-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="CylinderFillingExamineDto", description="液化气体气瓶充装信息审核")
public class CylinderFillingExamineDto  extends BaseDto {

   private static final long serialVersionUID = 1L;

 @ApiModelProperty(value = "id")

 private Long sequenceNbr;

 @ApiModelProperty(value = "充装信息审核ID")
 private String fillingExamineId;

 @ApiModelProperty(value = "报表生成时间")
 private String fillingAuditDate;

 @ApiModelProperty(value = "充装审核报表附件地址")
 private String fillingAuditUrl;

 @ApiModelProperty(value = "充装审核报表附件名称")
 private String fillingAuditName;

 @ApiModelProperty(value = "创建时间")
 private Date recDate;

 @ApiModelProperty(value = "操作人员")
 private String recUserId;

 @ApiModelProperty(value = "同步时间  yyyy-MM-dd HH24:mi:ss")
 private Date syncDate;

 @ApiModelProperty(value = "0-新增   1-更新  2-删除")
 private Integer syncState;

 @ApiModelProperty(value = "对接公司编码")
 private String appId;

 @ApiModelProperty(value = "数据完整度")
 private Double integrity;
}
