package com.yeejoin.amos.patrol.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

/**
 * The persistent class for the p_point_classify database table.
 *
 */
@Entity
@Table(name="p_point_classify")
@NamedQuery(name="PointClassify.findAll", query="SELECT p FROM PointClassify p")
public class PointClassify extends BasicEntity{
	private static final long serialVersionUID = 1L;

	/**
	 * 创建人id
	 */
	@Column(name="creator_id")
	private String creatorId;

	/**
	 * 点分类名称
	 */
	private String name;

	/**
	 * 排序号
	 */
	@Column(name="order_no")
	private int orderNo;

	/**
	 * 点id
	 */
	@Column(name="point_id")
	private long pointId;

	/**
	 * 原始字段
	 */
	@Column(name = "original_id", columnDefinition = "varchar(50) COMMENT '原始字段'")
	private String originalId;

	/**
	 * 装备id
	 */
	@Column(name="equipment_id")
	private String equipmentId;

	/**
	 * 巡查规范名称
	 */
	@Column(name="inspection_spec_name")
	private String inspectionSpecName;

	/**
	 * 编号
	 */
	@Column(name="code")
	private String code;

	/**
	 * 分类名称
	 */
	@Column(name="category_name")
	private String categoryName;

	/**
	 * 分类id
	 */
	@Column(name="category_code")
	private String categoryCode;

	/**
	 * 位置
	 */
	@Column(name="address")
	private String address;

	/**
	 * 数据源code(1 消防装备  2 重点部位 3 自定义)
	 */
	@Column(name="data_source_code")
	private String dataSourceCode;

	/**
	 * 数据源名称（冗余）
	 */
	@Column(name="data_source_name")
	private String dataSourceName;

	/**
	 * 是否删除（ 0未删除，1已删除 ）
	 */
	@Column(name="is_delete")
	private byte isDelete;

	/**
	 * 建筑id
	 */
	@Column(name="building_id")
	private String buildingId;

	/**
	 * 建筑名称
	 */
	@Column(name="building_name")
	private String buildingName;


	public String getEquipmentId() {
		return equipmentId;
	}

	public void setEquipmentId(String equipmentId) {
		this.equipmentId = equipmentId;
	}

	public String getInspectionSpecName() {
		return inspectionSpecName;
	}

	public void setInspectionSpecName(String inspectionSpecName) {
		this.inspectionSpecName = inspectionSpecName;
	}


	public PointClassify() {
	}

	public String getCreatorId() {
		return this.creatorId;
	}

	public void setCreatorId(String creatorId) {
		this.creatorId = creatorId;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public int getOrderNo() {
		return this.orderNo;
	}

	public void setOrderNo(int orderNo) {
		this.orderNo = orderNo;
	}

	public long getPointId() {
		return this.pointId;
	}

	public void setPointId(long pointId) {
		this.pointId = pointId;
	}

	public String getOriginalId() {
		return originalId;
	}

	public void setOriginalId(String originalId) {
		this.originalId = originalId;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getCategoryName() {
		return categoryName;
	}

	public void setCategoryName(String categoryName) {
		this.categoryName = categoryName;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getDataSourceCode() {
		return dataSourceCode;
	}

	public void setDataSourceCode(String dataSourceCode) {
		this.dataSourceCode = dataSourceCode;
	}

	public String getDataSourceName() {
		return dataSourceName;
	}

	public void setDataSourceName(String dataSourceName) {
		this.dataSourceName = dataSourceName;
	}

	public byte getIsDelete() {
		return isDelete;
	}

	public void setIsDelete(byte isDelete) {
		this.isDelete = isDelete;
	}

	public String getBuildingId() {
		return buildingId;
	}

	public void setBuildingId(String buildingId) {
		this.buildingId = buildingId;
	}

	public String getBuildingName() {
		return buildingName;
	}

	public void setBuildingName(String buildingName) {
		this.buildingName = buildingName;
	}

	public String getCategoryCode() {
		return categoryCode;
	}

	public void setCategoryCode(String categoryCode) {
		this.categoryCode = categoryCode;
	}
}