package com.yeejoin.amos.boot.module.app.biz.controller;

import com.yeejoin.amos.boot.module.app.biz.service.impl.TzsAuthServiceImpl;
import com.yeejoin.amos.component.robot.AmosRequestContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

@RestController
@Slf4j
@Api(tags = "wechat小程序接口")
@RequestMapping(value = "/wechat")
public class TzsWeChatController {

    @Autowired
    AmosRequestContext amosRequestContext;

    @Autowired
    TzsAuthServiceImpl authServiceImpl;

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "获取机器人登录token", notes = "获取机器人登录token")
    @GetMapping(value = "/api/acquireToken")
    synchronized public ResponseModel<String> getRobotLoginToken() {
        return ResponseHelper.buildResponse(authServiceImpl.getUserToken());
    }
}
