package com.yeejoin.amos.openapi.enums;

import com.google.common.collect.Lists;

import java.util.List;

/**
 * <pre>
 * 监管附件对象属性枚举
 * </pre>
 *
 * @author Zhang Yingbin
 */

public enum TaAccessConfigBizeEnum {
	
	LICENSE("license", "许可信息"),
	SSO("sso", "统一门户sso信息");

	/**
	 * 属性
	 */
	private String attribute;

	/**
	 * 对象
	 */
	private String object;

	TaAccessConfigBizeEnum(String attribute, String object) {
		this.attribute = attribute;
		this.object = object;
	}

	public static List<String> getBizTypeList() {
		List<String> bizTypeList = Lists.newArrayList();
		for (TaAccessConfigBizeEnum bizeEnum : TaAccessConfigBizeEnum.values()) {
			bizTypeList.add(bizeEnum.attribute);
		}
		return bizTypeList;
	}

	public String getAttribute() {
		return attribute;
	}

	public void setAttribute(String attribute) {
		this.attribute = attribute;
	}

	public String getObject() {
		return object;
	}

	public void setObject(String object) {
		this.object = object;
	}
}
