package com.yeejoin.amos.boot.module.jg.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.jg.api.common.BizCustomDateSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 设备移交
 *
 * @author system_generator
 * @date 2023-12-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "JgEquipTransferDto", description = "设备移交")
public class JgEquipTransferDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "申请编号")
    private String applyNo;

    @ApiModelProperty(value = "使用单位统一信用代码")
    private String useUnitCreditCode;

    @ApiModelProperty(value = "使用单位名称")
    private String useUnitName;

    @ApiModelProperty(value = "申请状态")
    private String applyStatus;

    @ApiModelProperty(value = "申请状态描述")
    private String applyStatusDesc;

    @ApiModelProperty(value = "申请日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private String applyDate;

    @ApiModelProperty(value = "施工单位统一信用代码")
    private String installUnitCreditCode;

    @ApiModelProperty(value = "施工单位名称")
    private String installUnitName;

    @ApiModelProperty(value = "设备数量")
    private Integer equipNum;

    @ApiModelProperty(value = "流程实例id")
    private String instanceId;

    @ApiModelProperty(value = "下步执行角色/人id")
    private String nextExecuteIds;

    @ApiModelProperty(value = "流程执行顺序标识")
    private String executeSequence;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date createDate;

    @ApiModelProperty(value = "创建人id ")
    private String createUserId;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "流程状态")
    private String instanceStatus;

    @ApiModelProperty(value = "受理完成日期")
    private Date acceptDate;

    @ApiModelProperty(value = "任务发起人id")
    private String promoter;

    @ApiModelProperty(value = "任务名称")
    private String taskName;

    @ApiModelProperty(value = "设备名称")
    private String productName;

    @ApiModelProperty(value = "流程执行角色")
    private String instanceRoles;

    @ApiModelProperty(value = "告知设备列表")
    private List<Map<String, Object>> deviceList;

    @ApiModelProperty(value = "设备类别")
    private String equCategory;

    @ApiModelProperty(value = "设备品种")
    private String equDefine;

    @ApiModelProperty(value = "设备出厂编号")
    private String factoryNum;

    @ApiModelProperty(value = "设备注册代码")
    private String equCode;

    @ApiModelProperty(value = "使用登记证编号")
    private String useOrgCode;

    @ApiModelProperty(value = "监管码")
    private String supervisoryCode;

    @ApiModelProperty(value = "设备种类")
    private String equList;

    @ApiModelProperty(value = "单位内编号")
    private String useInnerCode;

    @ApiModelProperty(value = "设备地址")
    private String equAddress;

    @ApiModelProperty(value = "详细地址")
    private String detailedAddress;

    @ApiModelProperty(value = "96333识别码")
    private String code96333;

    @ApiModelProperty(value = "流程建议")
    private String processAdvice;

    @ApiModelProperty(value = "使用单位统一信用代码-数据隔离使用")
    private String useUnitCodeFilter;

    @ApiModelProperty(value = "施工单位统一信用代码-数据隔离使用")
    private String installUnitCodeFilter;

    /**
     * 下一节点可执行人逗号分割
     */
    @ApiModelProperty(value = "下一节点可执行人逗号分割-数据隔离使用")
    private String nextExecuteUserIds;

    @ApiModelProperty(value = "转办人")
    private String transferToUserIds;


    @ApiModelProperty(value = "工作流下一节点任务id")
    private String nextTaskId;
}
