package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.excel.ExcelUtil;
import com.yeejoin.amos.boot.module.jg.api.dto.JgUseRegistrationDto;
import com.yeejoin.amos.boot.module.jg.api.mapper.*;
import com.yeejoin.amos.boot.module.jg.api.vo.tableDataExportVo.*;
import com.yeejoin.amos.boot.module.jg.biz.service.IJgTableDataExportService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * JG列表数据导出实现类
 */
@Slf4j
@Service
public class JgTableDataExportServiceImpl implements IJgTableDataExportService {

    @Autowired
    private JgUseRegistrationManageMapper useRegistrationManageMapper;
    @Autowired
    private JgMaintenanceContractMapper maintenanceContractMapper;
    @Autowired
    private JgInstallationNoticeServiceImpl installationNoticeService;
    @Autowired
    private JgMaintainNoticeServiceImpl maintainNoticeService;
    @Autowired
    private JgReformNoticeServiceImpl reformNoticeService;
    @Autowired
    private JgTransferNoticeServiceImpl transferNoticeService;
    @Autowired
    private JgUseRegistrationMapper registrationMapper;
    @Autowired
    private JgChangeRegistrationUnitMapper changeRegistrationUnitMapper;
    @Autowired
    private JgChangeRegistrationReformMapper changeRegistrationReformMapper;
    @Autowired
    private JgEnableDisableMapper enableDisableMapper;
    @Autowired
    private JgScrapCancelServiceImpl scrapCancelService;
    @Autowired
    private JgChangeRegistrationTransferMapper changeRegistrationTransferMapper;
    @Autowired
    private JgChangeRegistrationNameMapper changeRegistrationNameMapper;
    @Autowired
    private JgVehicleInformationMapper vehicleInformationMapper;
    @Autowired
    private JgChangeVehicleRegistrationUnitMapper changeVehicleRegistrationUnitMapper;
    @Autowired
    private IdxBizJgRegisterInfoServiceImpl idxBizJgRegisterInfoService;
    @Autowired
    private JgEquipTransferMapper equipTransferMapper;
    @Autowired
    private JgEquipTransferServiceImpl equipTransferService;


    @Override
    public void gen(String jsonName, String voName, String tableName) {
        String voContent = "package com.yeejoin.amos.boot.module.jg.api.vo.tableDataExportVo;\n" +
                "\n" +
                "import com.alibaba.excel.annotation.ExcelProperty;\n" +
                "import lombok.Data;\n" +
                "\n" +
                "/**\n" +
                " * %s\n" +
                " */\n" +
                "@Data\n" +
                "public class %s {\n";

        String tem = "    \n" +
                "    @ExcelProperty(value = \"%s\", index = %s)\n" +
                "    String %s;\n";
        final String jsonPrefix = "D:\\";
        String jsonPath = jsonPrefix + jsonName + ".json";
        final String voPrefix = "C:\\YeeJoinProjects\\amos-boot-biz\\amos-boot-system-tzs\\amos-boot-module-jg\\amos-boot-module-jg-api\\src\\main\\java\\com\\yeejoin\\amos\\boot\\module\\jg\\api\\vo\\tableDataExportVo";
        try {
            // 读取 JSON 文件内容为字符串
            String jsonContent = new String(Files.readAllBytes(Paths.get(jsonPath)));
            JSONObject js = JSON.parseObject(jsonContent);
            JSONObject uiobject = JSON.parseObject(JSON.toJSONString(js.get("uiobject")));
            JSONArray children = JSON.parseArray(JSON.toJSONString(uiobject.get("children")));
            JSONObject children0 = JSON.parseObject(JSON.toJSONString(children.get(0)));
            JSONObject visualParams = JSON.parseObject(JSON.toJSONString(children0.get("visualParams")));
            JSONArray target = JSON.parseArray(JSON.toJSONString(visualParams.get("columnsSetting")));

            String content = String.format(voContent, tableName, voName.substring(0, 1).toUpperCase() + voName.substring(1) + "Vo");
            for (int i = 0; i < target.size(); i++) {
                JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(target.get(i)));
                String title = String.valueOf(jsonObject.get("title"));
                String dataIndex = String.valueOf(jsonObject.get("dataIndex"));
                content = content + String.format(tem, title, i, dataIndex);
            }

            content = content + "}\n";

            // controller层
            String controller = String.format("@TycloudOperation(ApiLevel = UserType.AGENCY)\n" +
                    "    @GetMapping(value = \"/%s\")\n" +
                    "    @ApiOperation(httpMethod = \"GET\", value = \"%s列表数据导出\", notes = \"%s列表数据导出\")\n" +
                    "    public void " + "%s" + "Export(HttpServletResponse response, String ids) {\n" +
                    "        Assert.hasText(ids,\"未选择导出数据\");\n" +
                    "        iJgTableDataExportService." + "%s" + "(response, Arrays.asList(ids.split(\",\")));\n" +
                    "    }\n", voName, tableName, tableName, voName, voName);
            // interface层
            String interfac = String.format("void %s(HttpServletResponse response, List<String> ids);\n", voName);
            // server层
            String service = String.format("/**\n" +
                    "     * %s列表数据导出\n" +
                    "     *\n" +
                    "     * @param response 响应\n" +
                    "     * @param ids 数据id\n" +
                    "     */\n" +
                    "    @Override\n" +
                    "    public void %s(HttpServletResponse response, List<String> ids) {\n" +
                    "        List<%sVo> exportData = .query%sInIds(ids);\n" +
                    "        ExcelUtil.createTemplate(response, \"%s列表数据\", \"%s列表\", exportData, " + "%sVo" + ".class, null, false);\n" +
                    "    }\n", tableName, voName, voName.substring(0, 1).toUpperCase() + voName.substring(1), voName.substring(0, 1).toUpperCase() + voName.substring(1), tableName, tableName, voName.substring(0, 1).toUpperCase() + voName.substring(1));
            // mapper
            String mapper = String.format("List<%sVo> query%sInIds(@Param(\"ids\") List<String> ids);\n", voName.substring(0, 1).toUpperCase() + voName.substring(1)
                    , voName.substring(0, 1).toUpperCase() + voName.substring(1));
            // mapperxml
            String mapperxml = String.format("<select id=\"query%sInIds\" resultType=\"com.yeejoin.amos.boot.module.jg.api.vo.tableDataExportVo.%sVo\">\n" +
                            "        <include refid=\"page_list\"/>\n" +
                            "        from tzs_jg_use_registration_manage tjurm\n" +
                            "        <where>\n" +
                            "            <if test='ids != null'>\n" +
                            "                and tjurm.sequence_nbr in\n" +
                            "                <foreach collection=\"ids\" item=\"id\" open=\"(\" close=\")\" separator=\",\">\n" +
                            "                    #{id}\n" +
                            "                </foreach>\n" +
                            "            </if>\n" +
                            "        </where>\n" +
                            "    </select>\n", voName.substring(0, 1).toUpperCase() + voName.substring(1)
                    , voName.substring(0, 1).toUpperCase() + voName.substring(1));
            content = content + controller + interfac + service + mapper + mapperxml;
            Path filePath = Paths.get(voPrefix, voName.substring(0, 1).toUpperCase() + voName.substring(1) + "Vo" + ".java");
            Files.write(filePath, content.getBytes());
        } catch (IOException e) {
            e.printStackTrace(); // 处理文件读取错误
        }

    }

    /**
     * 登记证列表数据导出
     *
     * @param response 响应
     * @param ids      数据id
     */
    @Override
    public void certificate(HttpServletResponse response, List<String> ids) {
        List<CertificateVo> exportData = useRegistrationManageMapper.queryCertificateInIds(ids);
        ExcelUtil.createTemplate(response, "使用登记证列表数据", "使用登记证列表", exportData, CertificateVo.class, null, false);
    }

    /**
     * 维保备案列表数据导出
     *
     * @param response 响应
     * @param ids      数据id
     */
    @Override
    public void maintenance(HttpServletResponse response, List<String> ids) {
        List<MaintenanceVo> exportData = maintenanceContractMapper.queryMaintenanceInIds(ids);
        ExcelUtil.createTemplate(response, "维保备案列表数据", "维保备案列表", exportData, MaintenanceVo.class, null, false);
    }

    /**
     * 安装告知列表数据导出
     *
     * @param response 响应
     * @param ids      数据id
     */
    @Override
    public void installation(HttpServletResponse response, List<String> ids) {
        List<InstallationVo> exportData = installationNoticeService.queryInstallationInIds(ids);
        ExcelUtil.createTemplate(response, "安装告知列表数据", "安装告知列表", exportData, InstallationVo.class, null, false);
    }

    /**
     * 维修告知列表数据导出
     *
     * @param response 响应
     * @param ids 数据id
     */
    @Override
    public void maintain(HttpServletResponse response, List<String> ids) {
        List<MaintainVo> exportData = maintainNoticeService.queryMaintainInIds(ids);
        ExcelUtil.createTemplate(response, "维修告知列表数据", "维修告知列表", exportData, MaintainVo.class, null, false);
    }

    /**
     * 改造告知列表数据导出
     *
     * @param response 响应
     * @param ids 数据id
     */
    @Override
    public void reform(HttpServletResponse response, List<String> ids) {
        List<ReformVo> exportData = reformNoticeService.queryReformInIds(ids);
        ExcelUtil.createTemplate(response, "改造告知列表数据", "改造告知列表", exportData, ReformVo.class, null, false);
    }

    /**
     * 移装告知列表数据导出
     *
     * @param response 响应
     * @param ids 数据id
     */
    @Override
    public void transfer(HttpServletResponse response, List<String> ids) {
        List<TransferVo> exportData = transferNoticeService.queryTransferInIds(ids);
        ExcelUtil.createTemplate(response, "移装告知列表数据", "移装告知列表", exportData, TransferVo.class, null, false);
    }

    /**
     * 使用登记列表数据导出
     *
     * @param response 响应
     * @param dto 筛选面板数据
     */
    @Override
    public void registration(HttpServletResponse response, JgUseRegistrationDto dto, String client) {
        if (dto.getAuditPassDateRange() != null && !dto.getAuditPassDateRange().isEmpty() && !dto.getAuditPassDateRange().equals("[, ]")) {
            String dateRangeStr = dto.getAuditPassDateRange();
            String[] dates = dateRangeStr.replace("[", "").replace("]", "").split(", ");

            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date start = null;
            Date end = null;
            try {
                start = dateFormat.parse(dates[0]);
                end = dateFormat.parse(dates[1]);
            } catch (ParseException e) {
                throw new RuntimeException(e);
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(start);
            calendar.add(Calendar.DAY_OF_MONTH, -1); // 减去一天
            start = calendar.getTime();
            dto.setAuditPassDateStart(start);
            dto.setAuditPassDateEnd(end);
        }
        List<RegistrationVo> exportData = registrationMapper.queryRegistrationInIds(dto, client);
        for (RegistrationVo vo : exportData) {
            if (vo.getRegType()== null) {
                vo.setRegType("新增登记");
            } else if(vo.getRegType().equals("1")){
                vo.setRegType("历史登记");
            }
        }
        ExcelUtil.createTemplate(response, "使用登记列表数据", "使用登记列表", exportData, RegistrationVo.class, null, false);
    }

    /**
     * 单位变更列表数据导出
     *
     * @param response 响应
     * @param ids 数据id
     */
    @Override
    public void changeRegistrationUnit(HttpServletResponse response, List<String> ids) {
        List<ChangeRegistrationUnitVo> exportData = changeRegistrationUnitMapper.queryChangeRegistrationUnitInIds(ids);
        ExcelUtil.createTemplate(response, "单位变更列表数据", "单位变更列表", exportData, ChangeRegistrationUnitVo.class, null, false);
    }

    /**
     * 改造登记列表数据导出
     *
     * @param response 响应
     * @param ids 数据id
     */
    @Override
    public void changeRegistrationReform(HttpServletResponse response, List<String> ids) {
        List<ChangeRegistrationReformVo> exportData = changeRegistrationReformMapper.queryChangeRegistrationReformInIds(ids);
        ExcelUtil.createTemplate(response, "改造登记列表数据", "改造登记列表", exportData, ChangeRegistrationReformVo.class, null, false);
    }


    /**
     * 启用停用列表数据导出
     *
     * @param response 响应
     * @param ids 数据id
     */
    @Override
    public void enableDisable(HttpServletResponse response, List<String> ids) {
        List<EnableDisableVo> exportData = enableDisableMapper.queryEnableDisableInIds(ids);
        ExcelUtil.createTemplate(response, "启用停用列表数据", "启用停用列表", exportData, EnableDisableVo.class, null, false);
    }


    /**
     * 注销报废列表数据导出
     *
     * @param response 响应
     * @param ids 数据id
     */
    @Override
    public void scrapCancel(HttpServletResponse response, List<String> ids) {
        List<ScrapCancelVo> exportData = scrapCancelService.queryScrapCancelInIds(ids);
        ExcelUtil.createTemplate(response, "注销报废列表数据", "注销报废列表", exportData, ScrapCancelVo.class, null, false);
    }


    /**
     * 移装变更列表数据导出
     *
     * @param response 响应
     * @param ids 数据id
     */
    @Override
    public void changeRegistrationTransfer(HttpServletResponse response, List<String> ids) {
        List<ChangeRegistrationTransferVo> exportData = changeRegistrationTransferMapper.queryChangeRegistrationTransferInIds(ids);
        ExcelUtil.createTemplate(response, "移装变更列表数据", "移装变更列表", exportData, ChangeRegistrationTransferVo.class, null, false);
    }


    /**
     * 更名变更列表数据导出
     *
     * @param response 响应
     * @param ids 数据id
     */
    @Override
    public void changeRegistrationName(HttpServletResponse response, List<String> ids) {
        List<ChangeRegistrationNameVo> exportData = changeRegistrationNameMapper.queryChangeRegistrationNameInIds(ids);
        ExcelUtil.createTemplate(response, "更名变更列表数据", "更名变更列表", exportData, ChangeRegistrationNameVo.class, null, false);
    }



    /**
     * 车气登记列表数据导出
     *
     * @param response 响应
     * @param ids 数据id
     */
    @Override
    public void vehicleInformation(HttpServletResponse response, List<String> ids) {
        List<VehicleInformationVo> exportData = vehicleInformationMapper.queryVehicleInformationInIds(ids);
        ExcelUtil.createTemplate(response, "车气登记列表数据", "车气登记列表", exportData, VehicleInformationVo.class, null, false);
    }



    /**
     * 车用气瓶变更列表数据导出
     *
     * @param response 响应
     * @param ids 数据id
     */
    @Override
    public void changeVehicleRegistrationUnit(HttpServletResponse response, List<String> ids) {
        List<ChangeVehicleRegistrationUnitVo> exportData = changeVehicleRegistrationUnitMapper.queryChangeVehicleRegistrationUnitInIds(ids);
        ExcelUtil.createTemplate(response, "车用气瓶变更列表数据", "车用气瓶变更列表", exportData, ChangeVehicleRegistrationUnitVo.class, null, false);
    }


    /**
     * 未纳管设备列表数据导出
     *
     * @param response 响应
     * @param ids 数据id
     */
    @Override
    public void unregulatedEquip(HttpServletResponse response, List<String> ids) {
        List<JSONObject> jsonObjects = idxBizJgRegisterInfoService.queryEquipInIds(ids);
        List<UnregulatedEquipVo> exportData = JSON.parseArray(JSON.toJSONString(jsonObjects), UnregulatedEquipVo.class);
        ExcelUtil.createTemplate(response, "未纳管设备列表数据", "未纳管设备列表", exportData, UnregulatedEquipVo.class, null, false);
    }


    /**
     * 已纳管设备列表数据导出
     *
     * @param response 响应
     * @param ids 数据id
     */
    @Override
    public void manageEquipment(HttpServletResponse response, List<String> ids) {
        List<JSONObject> jsonObjects = idxBizJgRegisterInfoService.queryEquipInIds(ids);
        List<ManageEquipmentVo> exportData = JSON.parseArray(JSON.toJSONString(jsonObjects), ManageEquipmentVo.class);
        ExcelUtil.createTemplate(response, "已纳管设备列表数据", "已纳管设备列表", exportData, ManageEquipmentVo.class, null, false);
    }


    /**
     * 设备移交列表数据导出
     *
     * @param response 响应
     * @param ids 数据id
     */
    @Override
    public void equipTransfer(HttpServletResponse response, List<String> ids) {
        List<EquipTransferVo> exportData = equipTransferService.queryTransferInIds(ids);
        ExcelUtil.createTemplate(response, "设备移交列表数据", "设备移交列表", exportData, EquipTransferVo.class, null, false);
    }
}