//package com.yeejoin.amos.api.openapi.face.service;
//
//import com.alibaba.fastjson.JSONObject;
//import com.yeejoin.amos.api.openapi.enums.JgFileAttributeEnum;
//import com.yeejoin.amos.api.openapi.enums.JgFileObjectEnum;
//import com.yeejoin.amos.api.openapi.face.model.ElevatorTechInfoModel;
//import com.yeejoin.amos.api.openapi.face.orm.dao.ElevatorTechInfoMapper;
//import com.yeejoin.amos.api.openapi.face.orm.entity.ElevatorTechInfo;
//import com.yeejoin.amos.api.openapi.face.orm.entity.JgFile;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Component;
//import org.springframework.transaction.annotation.Transactional;
//import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
//import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
//
//import java.util.ArrayList;
//import java.util.Date;
//import java.util.List;
//
///**
// * 电梯技术参数 服务类
// *
// * @author duanwei
// * @date 2022-07-19
// */
//@Component
//public class ElevatorTechInfoService extends AppBaseService<ElevatorTechInfoModel, ElevatorTechInfo, ElevatorTechInfoMapper> {
//
//    @Autowired
//    private JgFileService fileService;
//
//    /**
//     *
//     * 新增电梯技术参数
//     *
//     * @param model 电梯技术参数实体类集合
//     * @return 成功返回“OK”
//     */
//    @Transactional(rollbackFor= {Exception.class})
//    public String saveElevatorTechInfo(List<ElevatorTechInfoModel> model) {
//        // TODO Auto-generated method stub
//        if (ValidationUtil.isEmpty(model)) {
//            throw new BadRequest("电梯技术参数为空.");
//        }
//
//        List<JgFile> fileList = new ArrayList<>();
//        List<JgFile> governorEffiReportList;
//
//        for (ElevatorTechInfoModel models : model) {
//            checkModel(models);
//            models.setRecDate(new Date());
//            models.setAppId(getAppId());
//
//            ElevatorTechInfoModel elevatorTechInfoModel = this.createWithModel(models);
//
//            governorEffiReportList = JSONObject.parseArray(JSONObject.toJSONString(models.getGovernorEffiReport()), JgFile.class);
//            for (JgFile files : governorEffiReportList) {
//                JgFile file = new JgFile();
//                file.setSequenceCode(models.getSequenceCode());
//                file.setAppId(getAppId());
//                file.setObjectType(JgFileObjectEnum.ELEVATOR_TECH_INFO.getObject());
//                file.setAttributeType(JgFileAttributeEnum.GOVERNOR_EFFI_REPORT.getAttribute());
//                file.setSyncDate(models.getSyncDate());
//                file.setFileUrl(files.getFileUrl());
//                file.setFileName(files.getFileName());
//                file.setRecDate(new Date());
//                file.setSquNbr(elevatorTechInfoModel.getSequenceNbr());
//                fileList.add(file);
//            }
//        }
//        fileService.saveBatch(fileList);
//        return "OK";
//    }
//
//    /**
//     * 信息校验
//     *
//     * @param models
//     */
//    private static void checkModel(ElevatorTechInfoModel models) {
//        if(ValidationUtil.isEmpty(models.getSequenceCode())) {
//            throw new BadRequest("设备唯一标识码不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSuperviseCode())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"监管系统唯一编码不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getRatedSpeed())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"额定速度不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getControlType())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"控制方式不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getRatedLoad())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"额定载重不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSyncDate())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"同步时间不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSyncState())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"同步状态不能为空！");
//        }
//    }
//}
