package com.yeejoin.amos.boot.module.common.api.dto;

import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 安全追溯-场内车辆
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@Group("5000")
public class VehicleTechParamDefine implements ITechParamDefine {


    @TechnicalParameter(key = "frameNo", label = "车架编号", type = TechnicalParameter.ParamType.STRING)
    private String frameNo;


    @TechnicalParameter(key = "engineNo", label = "发动机（行走电机）编号", type = TechnicalParameter.ParamType.STRING)
    private String engineNo;


    @TechnicalParameter(key = "liftingCapacity", equCategory = "5100", label = "额定起重量", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "Kg")
    private BigDecimal liftingCapacity;


    @TechnicalParameter(key = "transmissionMode", label = "传动方式", equCategory = "5100", type = TechnicalParameter.ParamType.STRING)
    private String transmissionMode;


    @TechnicalParameter(key = "weight", label = "自重", equCategory = "5100", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "Kg")
    private BigDecimal weight;

    @TechnicalParameter(key = "powerMode", label = "动力方式", equCategory = "5100", type = TechnicalParameter.ParamType.STRING)
    private String powerMode;


    @TechnicalParameter(key = "maxRunningSpeed", label = "最大运行速度", equCategory = {"5100", "5200"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "km/h")
    private BigDecimal maxRunningSpeed;



    @TechnicalParameter(key = "gasGroup", label = "气体/粉尘组别（防爆）", equCategory = "5100", type = TechnicalParameter.ParamType.STRING)
    private String gasGroup;


    @TechnicalParameter(key = "frameStructure", label = "车架结构", equCategory = "5100", type = TechnicalParameter.ParamType.STRING)
    private String frameStructure;


    @TechnicalParameter(key = "drivingMode", label = "驾驶方式", equCategory = "5100", type = TechnicalParameter.ParamType.STRING)
    private String drivingMode;


    @TechnicalParameter(key = "protectGrade", label = "设备保护等级（防爆）", equCategory = "5100", type = TechnicalParameter.ParamType.STRING, dictCode = "FBDJ")
    private String protectGrade;


    @TechnicalParameter(key = "temperatureGroup", label = "温度组别（防爆）", equCategory = "5100", type = TechnicalParameter.ParamType.STRING)
    private String temperatureGroup;


    @TechnicalParameter(key = "passengersNumber", label = "额定载客人数", equCategory = "5200", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "人")
    private BigDecimal passengersNumber;


    @TechnicalParameter(key = "maxDrivingSlope", label = "最大行驶坡度", equCategory = "5200", type = TechnicalParameter.ParamType.BIG_DECIMAL)
    private BigDecimal maxDrivingSlope;


    @TechnicalParameter(key = "vehicleMass", label = "整车整备质量", equCategory = "5200", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "Kg")
    private BigDecimal vehicleMass;


    @TechnicalParameter(key = "wheelBase", label = "轴距", equCategory = "5200", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "mm")
    private BigDecimal wheelBase;


    @TechnicalParameter(key = "trackWidthFront", label = "轮距（前）", equCategory = "5200", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "mm")
    private BigDecimal trackWidthFront;


    @TechnicalParameter(key = "trackWidthBehind", label = "轮距（后）", equCategory = "5200", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "mm")
    private BigDecimal trackWidthBehind;


    @TechnicalParameter(key = "carsNumber", label = "观光列车车厢数", equCategory = "5200", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "节")
    private BigDecimal carsNumber;


    @TechnicalParameter(key = "seatNumber", label = "观光列车每节车厢座位数", equCategory = "5200", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "个")
    private BigDecimal seatNumber;

    @TechnicalParameter(key = "tractorSeatNumber", label = "观光列车牵引车头座位数", equCategory = "5200", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "个")
    private BigDecimal tractorSeatNumber;

    @TechnicalParameter(key = "carryingIdlerMaxRunningSpeed", label = "空载最大运行速度", equCategory = "5100", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "km/h")
    private BigDecimal carryingIdlerMaxRunningSpeed;

    @TechnicalParameter(key = "maxLiftingHeight", label = "工作装置空载最大起升高度", equCategory = "5100", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "mm")
    private BigDecimal maxLiftingHeight;


}
