package com.yeejoin.amos.boot.module.jg.biz.utils;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.Comparator;
import java.util.List;

public class MemoryPageUtils {

    /**
     * 内存分页（支持排序）
     *
     * @param dataList   数据列表
     * @param current    当前页（从1开始）
     * @param size       每页大小
     * @param comparator 排序规则（可选，传null表示不排序）
     */
    public static <T> IPage<T> paginate(List<T> dataList, long current, long size, Comparator<T> comparator) {
        // 1. 参数校验
        if (current < 1 || size <= 0) {
            throw new IllegalArgumentException("分页参数错误：current >= 1 && size > 0");
        }

        // 2. 避免空指针
        if (dataList == null || dataList.isEmpty()) {
            return new Page<>(current, size, 0);
        }

        // 3. 排序（如果传入了comparator）
        if (comparator != null) {
            dataList.sort(comparator);
        }

        // 4. 计算分页区间
        long total = dataList.size();
        long fromIndex = (current - 1) * size;
        if (fromIndex >= total) {
            return new Page<>(current, size, total); // 超出范围返回空页
        }

        // 5. 手动分页
        List<T> pageRecords = dataList.subList(
                (int) fromIndex,
                (int) Math.min(fromIndex + size, total)
        );

        // 6. 构造IPage对象
        IPage<T> page = new Page<>(current, size, total);
        page.setRecords(pageRecords);
        return page;
    }

    // 简化版（不排序）
    public static <T> IPage<T> paginate(List<T> dataList, long current, long size) {
        return paginate(dataList, current, size, null);
    }
}
