package com.yeejoin.amos.boot.module.elevator.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.elevator.api.dto.ElevatorStatusHandleDto;
import com.yeejoin.amos.boot.module.elevator.api.entity.ElevatorStatus;
import com.yeejoin.amos.boot.module.elevator.api.enums.LiftBitStatusEnum;
import com.yeejoin.amos.boot.module.elevator.api.enums.LiftDirectionEnum;
import com.yeejoin.amos.boot.module.elevator.api.enums.LiftDoorStatusEnum;
import com.yeejoin.amos.boot.module.elevator.api.enums.LiftIszoneEnum;
import com.yeejoin.amos.boot.module.elevator.api.enums.LiftServiceModelEnum;
import com.yeejoin.amos.boot.module.elevator.api.enums.LiftStatusEnum;
import com.yeejoin.amos.boot.module.elevator.biz.service.impl.ElevatorStatusServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * 
 *
 * @author litw
 * @date 2021-09-28
 */
@RestController
@Api(tags = "物联电梯状态Api")
@RequestMapping(value = "/elevator-status")
public class ElevatorStatusController extends BaseController {

    @Autowired
    ElevatorStatusServiceImpl elevatorStatusServiceImpl;

	/**
	 * 根据电梯注册码查询物联信息
	 *
	 * @param registerCode  主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getElevatorStatus")
	@ApiOperation(httpMethod = "GET",value = "根据电梯注册码查询物联信息",  notes = "根据电梯注册码查询物联信息")
	public ResponseModel<ElevatorStatusHandleDto> selectOne(@RequestParam String registerCode) {
		LambdaQueryWrapper<ElevatorStatus> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(ElevatorStatus::getRegisterCode,registerCode);
		queryWrapper.orderByDesc(ElevatorStatus::getUploadDate);
		List<ElevatorStatus>  elevatorStatus = elevatorStatusServiceImpl.list(queryWrapper);
		if(null != elevatorStatus && elevatorStatus.size() > 0) {
			ElevatorStatus el = elevatorStatus.get(0);
			ElevatorStatusHandleDto dto = new ElevatorStatusHandleDto();

			dto.setDoorStatus(LiftDoorStatusEnum.getEnum(el.getDoorStatus()).getName());
			dto.setIsZone(LiftIszoneEnum.getEnum(el.getIsZone()).getName());
			dto.setLiftDirection(LiftDirectionEnum.getEnum(el.getLiftDirection()).getName());
			dto.setPersonFlag(LiftBitStatusEnum.getEnum(el.getPersonFlag()).getName());
			dto.setServiceModel(LiftServiceModelEnum.getEnum(el.getServiceModel()).getName());
			dto.setCurrFloor(el.getCurrFloor());
			dto.setLiftStatus(LiftStatusEnum.getEnum(el.getLiftStatus()).getName());
			return  ResponseHelper.buildResponse(dto);
		}

		return ResponseHelper.buildResponse(null);
	}
}
