package com.yeejoin.amos.boot.module.common.biz.service.impl;

import com.yeejoin.amos.boot.module.common.api.dao.ESEquipmentCategory;
import com.yeejoin.amos.boot.module.common.api.dto.ESEquipmentCategoryDto;
import lombok.RequiredArgsConstructor;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.stereotype.Service;

@Service
@RequiredArgsConstructor
public class EquipmentCategoryService {

    private final ESEquipmentCategory equipmentCategoryDao;

    private final ElasticsearchOperations elasticsearchOperations;

    public ESEquipmentCategoryDto saveWithImmediateRefresh(ESEquipmentCategoryDto dto) {
        ESEquipmentCategoryDto saved = equipmentCategoryDao.save(dto);
        // 手动触发索引刷新
        elasticsearchOperations.indexOps(ESEquipmentCategoryDto.class).refresh();
        return saved;
    }
}