package com.yeejoin.amos.boot.module.jczs.api.dto;

import com.yeejoin.amos.boot.module.jczs.api.entity.AlertFormValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
* 表表单初始值
*
* @author tb
* @date 2021-06-17
*/
@Data
@ApiModel(value="AlertFormInitDto", description="表单初始值")
public class AlertFormInitDto implements Serializable{

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "表单key")
    private String key;

    @ApiModelProperty(value = "表单名称")
    private String label;

    @ApiModelProperty(value = "表单类型")
    private String type;

    @ApiModelProperty(value = "表单默认值")
    private Object defaultValue;
    
    @ApiModelProperty(value = "表单值")
    private Items data;

    @ApiModelProperty(value = "提交表单附加字段")
    private AlertFormValue formItemDescr;
    
    @ApiModelProperty(value = "接口地址")
    private String url;
    
    
	public AlertFormInitDto() {
		
		super();
	}
	public AlertFormInitDto(String key, String label, String type, Items data, String url) {
		super();		
		this.key = key;
		this.label = label;
		this.type = type;
		this.data = data;
		this.url = url;
	}

    

}
