package com.yeejoin.amos.boot.module.jg.api.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

/**
 * 使用登记业务类型枚举
 *
 * @author Administrator
 */
@Getter
public enum RegOrgEnum {

    /**
     * 使用登记业务类型枚举
     */
    REG_ORG("0", "非西安市场监督管理局"),
    REG_ORG_610102("1", "新城区市场监督管理局"),
    REG_ORG_610103("2", "碑林区市场监督管理局"),
    REG_ORG_610104("3", "莲湖区市场监督管理局"),
    REG_ORG_610111("4", "灞桥区市场监督管理局"),
    REG_ORG_610112("5", "未央区市场监督管理局"),
    REG_ORG_610113("6", "雁塔区市场监督管理局"),
    REG_ORG_610114("7", "阎良区市场监督管理局"),
    REG_ORG_610115("8", "临潼区市场监督管理局"),
    REG_ORG_610116("9", "长安区市场监督管理局"),
    REG_ORG_610122("10", "蓝田县市场监督管理局"),
    REG_ORG_610124("11", "周至县市场监督管理局"),
    REG_ORG_610125("12", "鄠邑区市场监督管理局"),
    REG_ORG_610126("13", "高陵区市场监督管理局"),
    REG_ORG_610132("14", "经开区分局"),
    REG_ORG_610131("15", "高新区分局"),
    REG_ORG_610169100("16", "港务浐灞分局"),
    REG_ORG_610133("17", "曲江新区分局");


    private final String code;

    private final String name;

    RegOrgEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }


    public static Optional<String> getNameByCode(String code) {
        return Arrays.stream(RegTypeEnum.values())
                .filter(e -> e.getCode().equals(code))
                .map(RegTypeEnum::getName)
                .findFirst();
    }

    public static Optional<String> getCodeByName(String name) {
        return Arrays.stream(RegTypeEnum.values())
                .filter(e -> e.getName().equals(name))
                .map(RegTypeEnum::getCode)
                .findFirst();
    }
}
